/*
 * Decompiled with CFR 0.152.
 */
package mb.pie.api;

import java.io.Serializable;
import mb.pie.api.InconsistentTaskReq;
import mb.pie.api.TaskKey;
import mb.pie.api.stamp.OutputStamp;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TaskRequireDep
implements Serializable {
    public final TaskKey callee;
    public final OutputStamp stamp;

    public TaskRequireDep(TaskKey callee, OutputStamp stamp) {
        this.callee = callee;
        this.stamp = stamp;
    }

    public @Nullable InconsistentTaskReq checkConsistency(@Nullable Serializable output) {
        OutputStamp newStamp = this.stamp.getStamper().stamp(output);
        if (!this.stamp.equals(newStamp)) {
            return new InconsistentTaskReq(this, newStamp);
        }
        return null;
    }

    public Boolean isConsistent(@Nullable Serializable output) {
        OutputStamp newStamp = this.stamp.getStamper().stamp(output);
        return this.stamp.equals(newStamp);
    }

    public Boolean calleeEqual(TaskKey other) {
        return other.equals(this.callee);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskRequireDep that = (TaskRequireDep)o;
        if (!this.callee.equals(that.callee)) {
            return false;
        }
        return this.stamp.equals(that.stamp);
    }

    public int hashCode() {
        int result = this.callee.hashCode();
        result = 31 * result + this.stamp.hashCode();
        return result;
    }

    public String toString() {
        return "TaskReq(" + this.callee.toShortString(100) + ", " + this.stamp + ")";
    }
}

