/*
 * Decompiled with CFR 0.152.
 */
package mb.pie.api.stamp.resource;

import java.util.Arrays;
import javax.xml.bind.DatatypeConverter;
import mb.pie.api.stamp.ResourceStamp;
import mb.pie.api.stamp.ResourceStamper;
import mb.resource.Resource;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ByteArrayResourceStamp<R extends Resource>
implements ResourceStamp<R> {
    private final byte[] value;
    private final ResourceStamper<R> stamper;

    public ByteArrayResourceStamp(byte[] value, ResourceStamper<R> stamper) {
        this.value = value;
        this.stamper = stamper;
    }

    @Override
    public ResourceStamper<R> getStamper() {
        return this.stamper;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteArrayResourceStamp that = (ByteArrayResourceStamp)o;
        if (!Arrays.equals(this.value, that.value)) {
            return false;
        }
        return this.stamper.equals(that.stamper);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.value);
        result = 31 * result + this.stamper.hashCode();
        return result;
    }

    public String toString() {
        return "ByteArrayResourceStamp(value=" + DatatypeConverter.printHexBinary((byte[])this.value) + ", stamper=" + this.stamper + ')';
    }
}

