/*
 * Decompiled with CFR 0.152.
 */
package mb.pie.api.stamp.resource;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.stream.Stream;
import mb.resource.ReadableResource;
import mb.resource.hierarchical.HierarchicalResource;
import mb.resource.hierarchical.match.ResourceMatcher;
import mb.resource.hierarchical.walk.ResourceWalker;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Hash {
    private final MessageDigest digest;

    Hash() {
        try {
            this.digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    void update(ReadableResource resource) throws IOException {
        if (!resource.exists()) {
            this.updateNonExistent();
        } else {
            this.updateResource(resource);
        }
    }

    void update(HierarchicalResource resource, @Nullable ResourceMatcher matcher) throws IOException {
        if (!resource.exists()) {
            this.updateNonExistent();
        } else if (resource.isFile()) {
            this.updateResource(resource);
        } else if (resource.isDirectory()) {
            this.updateDir(resource, matcher);
        }
    }

    void updateRec(HierarchicalResource resource, @Nullable ResourceWalker walker, @Nullable ResourceMatcher matcher) throws IOException {
        if (!resource.exists()) {
            this.updateNonExistent();
        } else if (resource.isFile()) {
            this.updateResource(resource);
        } else if (resource.isDirectory()) {
            this.updateDirRec(resource, walker, matcher);
        }
    }

    private void updateNonExistent() {
        this.digest.update((byte)0);
    }

    private void updateResource(ReadableResource file) throws IOException {
        this.digest.update((byte)1);
        this.digest.update(file.readBytes());
    }

    private void updateDir(HierarchicalResource dir, @Nullable ResourceMatcher matcher) throws IOException {
        boolean useMatcher = matcher != null;
        try (Stream<? extends HierarchicalResource> stream = useMatcher ? dir.list(matcher) : dir.list();){
            stream.forEach(resource -> {
                try {
                    this.updateResource((ReadableResource)resource);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private void updateDirRec(HierarchicalResource dir, @Nullable ResourceWalker walker, @Nullable ResourceMatcher matcher) throws IOException {
        boolean useWalker = walker != null && matcher != null;
        try (Stream<? extends HierarchicalResource> stream = useWalker ? dir.walk(walker, matcher) : dir.walk();){
            stream.forEach(resource -> {
                try {
                    this.updateResource((ReadableResource)resource);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    byte[] getHashBytesAndReset() {
        return this.digest.digest();
    }
}

