/*
 * Decompiled with CFR 0.152.
 */
package mb.resource;

import java.io.Serializable;
import java.util.HashMap;
import mb.resource.Resource;
import mb.resource.ResourceKey;
import mb.resource.ResourceKeyString;
import mb.resource.ResourceRegistry;
import mb.resource.ResourceRuntimeException;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class HashMapResourceRegistry
implements ResourceRegistry {
    private final String qualifier;
    private final HashMap<Serializable, Resource> resources = new HashMap();

    public HashMapResourceRegistry(String qualifier) {
        this.qualifier = qualifier;
    }

    @Override
    public String qualifier() {
        return this.qualifier;
    }

    @Override
    public Resource getResource(Serializable id) {
        @Nullable Resource resource = this.resources.get(id);
        if (resource == null) {
            throw new ResourceRuntimeException("Cannot get resource with identifier '" + id + "'; it was not found in this registry");
        }
        return resource;
    }

    @Override
    public Resource getResource(ResourceKeyString keyStr) {
        if (!keyStr.qualifierMatchesOrMissing(this.qualifier)) {
            throw new ResourceRuntimeException("Qualifier of '" + keyStr + "' does not match qualifier '" + this.qualifier + "' of this resource registry");
        }
        Serializable id = this.toId(keyStr);
        @Nullable Resource resource = this.resources.get(id);
        if (resource == null) {
            throw new ResourceRuntimeException("Cannot get resource with identifier '" + id + "'; it was not found in this registry");
        }
        return resource;
    }

    protected abstract Serializable toId(ResourceKeyString var1);

    protected boolean addResource(Resource resource) {
        ResourceKey key = resource.getKey();
        String qualifier = key.getQualifier();
        if (!this.qualifier.equals(qualifier)) {
            throw new ResourceRuntimeException("Cannot add resource '" + resource + "' to registry; its qualifier '" + qualifier + "' does not match qualifier '" + this.qualifier + "' of the registry");
        }
        @Nullable Resource oldResource = this.resources.put(key.getId(), resource);
        return oldResource != null;
    }

    protected boolean removeResource(Resource resource) {
        ResourceKey key = resource.getKey();
        String qualifier = key.getQualifier();
        if (!this.qualifier.equals(qualifier)) {
            throw new ResourceRuntimeException("Cannot remove resource '" + resource + "' from registry; its qualifier '" + qualifier + "' does not match qualifier '" + this.qualifier + "' of the registry");
        }
        return this.removeResource(key.getId());
    }

    protected boolean removeResource(Serializable id) {
        @Nullable Resource oldResource = this.resources.remove(id);
        return oldResource != null;
    }
}

