/*
 * Decompiled with CFR 0.152.
 */
package mb.resource;

import mb.resource.DefaultResourceKeyString;
import mb.resource.QualifiedResourceKeyString;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface ResourceKeyString {
    public static ResourceKeyString of(String id) {
        return new DefaultResourceKeyString(id);
    }

    public static ResourceKeyString of(@Nullable String qualifier, String id) {
        return new DefaultResourceKeyString(qualifier != null ? (qualifier.isEmpty() ? null : qualifier) : null, id);
    }

    public static ResourceKeyString parse(String keyStr) {
        String[] split = keyStr.split("##", 2);
        if (split.length < 2) {
            return new DefaultResourceKeyString(keyStr);
        }
        String qualifier = split[0];
        return new DefaultResourceKeyString(qualifier.isEmpty() ? null : qualifier, split[1]);
    }

    public static String toString(@Nullable String qualifier, String id) {
        return (qualifier == null || qualifier.isEmpty() ? "" : qualifier) + "##" + id;
    }

    public @Nullable String getQualifier();

    default public boolean hasQualifier() {
        return this.getQualifier() != null;
    }

    default public boolean qualifierMatches(String qualifier) {
        return this.getQualifier() != null && qualifier.equals(this.getQualifier());
    }

    default public boolean qualifierMatchesOrMissing(String qualifier) {
        return this.getQualifier() == null || qualifier.matches(this.getQualifier());
    }

    public String getId();

    default public QualifiedResourceKeyString withQualifier(String qualifier) {
        return QualifiedResourceKeyString.of(qualifier, this.getId());
    }

    public String toString();
}

