/*
 * Decompiled with CFR 0.152.
 */
package mb.resource;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import mb.resource.ReadableResource;

public interface WritableResource
extends ReadableResource {
    public boolean isWritable() throws IOException;

    public void setLastModifiedTime(Instant var1) throws IOException;

    public OutputStream openWrite() throws IOException;

    public OutputStream openWriteAppend() throws IOException;

    public OutputStream openWriteExisting() throws IOException;

    public OutputStream openWriteNew() throws IOException;

    default public void writeBytes(byte[] bytes) throws IOException {
        try (OutputStream outputStream = this.openWriteExisting();){
            outputStream.write(bytes);
            outputStream.flush();
        }
    }

    default public void writeString(String string, Charset toCharset) throws IOException {
        try (OutputStream outputStream = this.openWriteExisting();){
            outputStream.write(string.getBytes(toCharset));
            outputStream.flush();
        }
    }

    default public void writeString(String string) throws IOException {
        this.writeString(string, StandardCharsets.UTF_8);
    }
}

