/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.classloader;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import mb.resource.ResourceRuntimeException;
import mb.resource.hierarchical.PathNormalizerUtil;
import mb.resource.hierarchical.ResourcePath;
import mb.resource.hierarchical.ResourcePathDefaults;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ClassLoaderResourcePath
extends ResourcePathDefaults<ClassLoaderResourcePath>
implements ResourcePath {
    private final String qualifier;
    private final Identifier id;

    ClassLoaderResourcePath(String qualifier, Identifier id) {
        this.qualifier = qualifier;
        this.id = id;
    }

    ClassLoaderResourcePath(String qualifier, String id) {
        this.qualifier = qualifier;
        this.id = Identifier.fromString(id);
    }

    @Override
    public String getQualifier() {
        return this.qualifier;
    }

    @Override
    public Identifier getId() {
        return this.id;
    }

    @Override
    public boolean isAbsolute() {
        return this.id.isAbsolute();
    }

    @Override
    public int getSegmentCount() {
        return this.id.segments.size();
    }

    @Override
    public Iterable<String> getSegments() {
        return this.id.segments;
    }

    @Override
    public @Nullable ClassLoaderResourcePath getParent() {
        @Nullable Identifier parent = this.id.getParent();
        if (parent == null) {
            return null;
        }
        return new ClassLoaderResourcePath(this.qualifier, parent);
    }

    @Override
    public @Nullable ClassLoaderResourcePath getRoot() {
        @Nullable Identifier root = this.id.getRoot();
        if (root == null) {
            return null;
        }
        return new ClassLoaderResourcePath(this.qualifier, root);
    }

    @Override
    public @Nullable String getLeaf() {
        return this.id.getLeaf();
    }

    @Override
    public ClassLoaderResourcePath getNormalized() {
        return new ClassLoaderResourcePath(this.qualifier, this.id.getNormalized());
    }

    @Override
    public ClassLoaderResourcePath relativize(ResourcePath other) {
        if (!(other instanceof ClassLoaderResourcePath)) {
            throw new ResourceRuntimeException("Cannot relativize with path '" + other + "', it is not a ClassLoaderResourcePath");
        }
        return this.relativize((ClassLoaderResourcePath)other);
    }

    public ClassLoaderResourcePath relativize(ClassLoaderResourcePath other) {
        return new ClassLoaderResourcePath(this.qualifier, this.id.relativize(other.id));
    }

    @Override
    public String relativizeToString(ResourcePath other) {
        if (!(other instanceof ClassLoaderResourcePath)) {
            throw new ResourceRuntimeException("Cannot relativize with path '" + other + "', it is not a ClassLoaderResourcePath");
        }
        return this.relativizeToString((ClassLoaderResourcePath)other);
    }

    public String relativizeToString(ClassLoaderResourcePath other) {
        return this.id.relativize(other.id).toString();
    }

    @Override
    public ClassLoaderResourcePath appendSegment(String segment) {
        return new ClassLoaderResourcePath(this.qualifier, this.id.appendSegment(segment));
    }

    @Override
    public ClassLoaderResourcePath appendSegments(Iterable<String> segments) {
        return new ClassLoaderResourcePath(this.qualifier, this.id.appendSegments(segments));
    }

    @Override
    public ClassLoaderResourcePath appendSegments(Collection<String> segments) {
        return new ClassLoaderResourcePath(this.qualifier, this.id.appendSegments(segments));
    }

    @Override
    public ClassLoaderResourcePath appendRelativePath(String relativePath) {
        return new ClassLoaderResourcePath(this.qualifier, this.id.appendRelativePath(relativePath));
    }

    @Override
    public ClassLoaderResourcePath appendOrReplaceWithPath(String other) {
        return new ClassLoaderResourcePath(this.qualifier, this.id.appendOrReplaceWithPath(other));
    }

    @Override
    public ClassLoaderResourcePath appendString(String other) {
        return new ClassLoaderResourcePath(this.qualifier, this.id.appendString(other));
    }

    @Override
    public ClassLoaderResourcePath appendRelativePath(ResourcePath relativePath) {
        if (!(relativePath instanceof ClassLoaderResourcePath)) {
            throw new ResourceRuntimeException("Cannot append '" + relativePath + "', it is not a ClassLoaderResourcePath");
        }
        return this.appendRelativePath((ClassLoaderResourcePath)relativePath);
    }

    public ClassLoaderResourcePath appendRelativePath(ClassLoaderResourcePath relativePath) {
        return new ClassLoaderResourcePath(this.qualifier, this.id.appendRelativePath(relativePath.id));
    }

    @Override
    public ClassLoaderResourcePath replaceLeaf(String segment) {
        return new ClassLoaderResourcePath(this.qualifier, this.id.replaceLeaf(segment));
    }

    @Override
    protected ClassLoaderResourcePath self() {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassLoaderResourcePath that = (ClassLoaderResourcePath)o;
        return this.qualifier.equals(that.qualifier) && this.id.equals(that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.qualifier, this.id);
    }

    @Override
    public String toString() {
        return this.id.toString();
    }

    public static class Identifier
    implements Serializable {
        private final @Nullable String root;
        private final List<String> segments;

        private Identifier(@Nullable String root, List<String> segments) {
            this.root = root;
            this.segments = segments;
        }

        private Identifier(List<String> segments) {
            this(null, segments);
        }

        private Identifier(String root) {
            this(root, new ArrayList<String>());
        }

        private static Identifier fromString(String str) {
            String[] segments = str.split("/");
            String root = str.startsWith("/") ? "/" : null;
            return new Identifier(root, Arrays.asList(segments));
        }

        private boolean isAbsolute() {
            return this.root != null;
        }

        private @Nullable Identifier getParent() {
            int size = this.segments.size();
            if (size > 1) {
                return new Identifier(this.root, new ArrayList<String>(this.segments.subList(0, size - 1)));
            }
            if (size > 0 && this.root != null) {
                return new Identifier(this.root);
            }
            return null;
        }

        private @Nullable Identifier getRoot() {
            if (this.root != null) {
                return new Identifier(this.root);
            }
            return null;
        }

        private @Nullable String getLeaf() {
            int size = this.segments.size();
            if (size > 0) {
                return this.segments.get(size - 1);
            }
            return this.root;
        }

        private Identifier getNormalized() {
            ArrayList<String> newSegments = PathNormalizerUtil.normalize(this.segments, this.segments.size());
            return new Identifier(this.root, newSegments);
        }

        private Identifier relativize(Identifier other) {
            int segmentsSize = this.segments.size();
            if (segmentsSize > other.segments.size()) {
                throw new ResourceRuntimeException("Cannot relativize path '" + other + "' to this path '" + this + "', this path has more segments");
            }
            for (int i = 0; i < segmentsSize; ++i) {
                if (this.segments.get(i).equals(other.segments.get(i))) continue;
                throw new ResourceRuntimeException("Cannot relativize path '" + other + "' to this path '" + this + "', there is no common root");
            }
            return new Identifier(this.root, new ArrayList<String>(other.segments.subList(segmentsSize, other.segments.size())));
        }

        public Identifier appendSegment(String segment) {
            ArrayList<String> newSegments = new ArrayList<String>(this.segments.size() + 1);
            newSegments.addAll(this.segments);
            newSegments.add(segment);
            return new Identifier(this.root, newSegments);
        }

        public Identifier appendSegments(Iterable<String> segments) {
            ArrayList<String> newSegments = new ArrayList<String>(this.segments);
            segments.forEach(newSegments::add);
            return new Identifier(this.root, newSegments);
        }

        public Identifier appendSegments(Collection<String> segments) {
            ArrayList<String> newSegments = new ArrayList<String>(this.segments.size() + segments.size());
            newSegments.addAll(this.segments);
            newSegments.addAll(segments);
            return new Identifier(this.root, newSegments);
        }

        public Identifier appendSegments(String ... segments) {
            return this.appendSegments((Collection<String>)Arrays.asList(segments));
        }

        public Identifier appendRelativePath(String relativePath) {
            if (relativePath.startsWith("/")) {
                throw new ResourceRuntimeException("Cannot append '" + relativePath + "', it is an absolute path");
            }
            String[] relativePathSegments = relativePath.split("/");
            return this.appendSegments(relativePathSegments);
        }

        public Identifier appendOrReplaceWithPath(String other) {
            String[] relativePathSegments = other.split("/");
            if (other.startsWith("/")) {
                return new Identifier("/", Arrays.asList(relativePathSegments));
            }
            return this.appendSegments(relativePathSegments);
        }

        public Identifier appendString(String other) {
            String[] pathSegments = other.split("/");
            return this.appendSegments(pathSegments);
        }

        public Identifier appendRelativePath(Identifier relativePath) {
            if (relativePath.isAbsolute()) {
                throw new ResourceRuntimeException("Cannot append '" + relativePath + "', it is an absolute path");
            }
            return this.appendSegments((Collection<String>)relativePath.segments);
        }

        public Identifier appendOrReplaceWithPath(Identifier other) {
            if (other.isAbsolute()) {
                return other;
            }
            return this.appendSegments((Collection<String>)other.segments);
        }

        public Identifier replaceLeaf(String segment) {
            int size = this.segments.size();
            if (size > 0) {
                ArrayList<String> newSegments = new ArrayList<String>(this.segments);
                newSegments.set(size - 1, segment);
                return new Identifier(this.root, newSegments);
            }
            if (this.root != null) {
                return new Identifier(segment);
            }
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Identifier that = (Identifier)o;
            return Objects.equals(this.root, that.root) && this.segments.equals(that.segments);
        }

        public int hashCode() {
            return Objects.hash(this.root, this.segments);
        }

        public String toString() {
            return (this.root != null ? this.root : "") + String.join((CharSequence)"/", this.segments);
        }
    }
}

