/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.classloader;

import java.io.Serializable;
import java.util.Objects;
import mb.resource.QualifiedResourceKeyString;
import mb.resource.ResourceKeyString;
import mb.resource.ResourceRegistry;
import mb.resource.ResourceRuntimeException;
import mb.resource.classloader.ClassLoaderResource;
import mb.resource.classloader.ClassLoaderResourcePath;

public class ClassLoaderResourceRegistry
implements ResourceRegistry {
    private static final String defaultQualifier = "classloader-resource";
    private final String qualifier;
    private final ClassLoader classLoader;

    public ClassLoaderResourceRegistry(String qualifier, ClassLoader classLoader) {
        this.qualifier = qualifier;
        this.classLoader = classLoader;
    }

    public ClassLoaderResourceRegistry(ClassLoader classLoader) {
        this(defaultQualifier, classLoader);
    }

    public ClassLoaderResourceRegistry() {
        this(defaultQualifier, ClassLoaderResourceRegistry.class.getClassLoader());
    }

    @Override
    public String qualifier() {
        return this.qualifier;
    }

    @Override
    public ClassLoaderResource getResource(Serializable id) {
        if (!(id instanceof ClassLoaderResourcePath.Identifier)) {
            throw new ResourceRuntimeException("Cannot get class loader resource with ID '" + id + "'; the ID is not of type ClassLoaderResourcePath.Identifier");
        }
        ClassLoaderResourcePath.Identifier identifier = (ClassLoaderResourcePath.Identifier)id;
        ClassLoaderResourcePath path = new ClassLoaderResourcePath(this.qualifier, identifier);
        return new ClassLoaderResource(this.classLoader, path);
    }

    @Override
    public ClassLoaderResourcePath getResourceKey(ResourceKeyString keyStr) {
        if (!keyStr.qualifierMatchesOrMissing(this.qualifier)) {
            throw new ResourceRuntimeException("Qualifier of '" + keyStr + "' does not match qualifier '" + this.qualifier + "' of this resource registry");
        }
        return new ClassLoaderResourcePath(this.qualifier, keyStr.getId());
    }

    @Override
    public ClassLoaderResource getResource(ResourceKeyString keyStr) {
        if (!keyStr.qualifierMatchesOrMissing(this.qualifier)) {
            throw new ResourceRuntimeException("Qualifier of '" + keyStr + "' does not match qualifier '" + this.qualifier + "' of this resource registry");
        }
        ClassLoaderResourcePath path = new ClassLoaderResourcePath(this.qualifier, keyStr.getId());
        return new ClassLoaderResource(this.classLoader, path);
    }

    @Override
    public QualifiedResourceKeyString toResourceKeyString(Serializable id) {
        if (!(id instanceof ClassLoaderResourcePath.Identifier)) {
            throw new ResourceRuntimeException("Cannot convert identifier '" + id + "' to its string representation; it is not of type ClassLoaderResourcePath.Identifier");
        }
        ClassLoaderResourcePath.Identifier identifier = (ClassLoaderResourcePath.Identifier)id;
        return QualifiedResourceKeyString.of(this.qualifier, identifier.toString());
    }

    @Override
    public String toString(Serializable id) {
        if (!(id instanceof ClassLoaderResourcePath.Identifier)) {
            throw new ResourceRuntimeException("Cannot convert identifier '" + id + "' to its string representation; it is not of type ClassLoaderResourcePath.Identifier");
        }
        ClassLoaderResourcePath.Identifier identifier = (ClassLoaderResourcePath.Identifier)id;
        return QualifiedResourceKeyString.toString(this.qualifier, identifier.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassLoaderResourceRegistry that = (ClassLoaderResourceRegistry)o;
        return this.qualifier.equals(that.qualifier) && this.classLoader.equals(that.classLoader);
    }

    public int hashCode() {
        return Objects.hash(this.qualifier, this.classLoader);
    }

    public String toString() {
        return "ClassLoaderResourceRegistry{qualifier='" + this.qualifier + '\'' + ", classLoader=" + this.classLoader + '}';
    }
}

