/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.fs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import mb.resource.ResourceRuntimeException;
import mb.resource.fs.FSPath;
import mb.resource.fs.ResourceWalkerFileVisitor;
import mb.resource.hierarchical.HierarchicalResource;
import mb.resource.hierarchical.HierarchicalResourceAccess;
import mb.resource.hierarchical.HierarchicalResourceDefaults;
import mb.resource.hierarchical.HierarchicalResourceType;
import mb.resource.hierarchical.ResourcePath;
import mb.resource.hierarchical.ResourcePathDefaults;
import mb.resource.hierarchical.match.ResourceMatcher;
import mb.resource.hierarchical.walk.ResourceWalker;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FSResource
extends HierarchicalResourceDefaults<FSResource>
implements HierarchicalResource,
Serializable {
    final FSPath path;

    public FSResource(FSPath path) {
        this.path = path;
    }

    public FSResource(Path javaPath) {
        this.path = new FSPath(javaPath);
    }

    public FSResource(URI uri) {
        this.path = new FSPath(uri);
    }

    public FSResource(File file) {
        this.path = new FSPath(file);
    }

    public FSResource(String localPathStr) {
        this.path = new FSPath(localPathStr);
    }

    @Override
    public void close() {
    }

    public static FSResource workingDirectory() {
        return new FSResource(FSPath.workingDirectory());
    }

    public static FSResource homeDirectory() {
        return new FSResource(FSPath.homeDirectory());
    }

    public static FSResource temporaryDirectory() {
        return new FSResource(FSPath.temporaryDirectory());
    }

    public static FSResource createTemporaryDirectory(String prefix) throws IOException {
        return new FSResource(Files.createTempDirectory(prefix, new FileAttribute[0]));
    }

    public static FSResource createTemporaryDirectory(FSResource directory, String prefix) throws IOException {
        return new FSResource(Files.createTempDirectory(directory.path.javaPath, prefix, new FileAttribute[0]));
    }

    public static FSResource createTemporaryFile(String prefix, String suffix) throws IOException {
        return new FSResource(Files.createTempFile(prefix, suffix, new FileAttribute[0]));
    }

    public static FSResource createTemporaryFile(FSResource directory, String prefix, String suffix) throws IOException {
        return new FSResource(Files.createTempFile(directory.path.javaPath, prefix, suffix, new FileAttribute[0]));
    }

    @Override
    public FSPath getPath() {
        return this.path;
    }

    @Override
    public FSPath getKey() {
        return this.path;
    }

    public Path getJavaPath() {
        return this.path.javaPath;
    }

    public URI getURI() {
        return this.path.uri;
    }

    public boolean isLocalPath() {
        return this.path.javaPath.getFileSystem().equals(FileSystems.getDefault());
    }

    @Override
    public @Nullable FSResource getParent() {
        @Nullable FSPath newPath = this.path.getParent();
        if (newPath == null) {
            return null;
        }
        return new FSResource(newPath);
    }

    @Override
    public @Nullable FSResource getRoot() {
        @Nullable FSPath newPath = this.path.getRoot();
        if (newPath == null) {
            return null;
        }
        return new FSResource(newPath);
    }

    @Override
    public FSResource appendSegment(String segment) {
        FSPath newPath = this.path.appendSegment(segment);
        return new FSResource(newPath);
    }

    @Override
    public FSResource appendSegments(Iterable<String> segments) {
        ResourcePathDefaults newPath = this.path.appendSegments((Iterable)segments);
        return new FSResource((FSPath)newPath);
    }

    @Override
    public FSResource appendSegments(Collection<String> segments) {
        ResourcePathDefaults newPath = this.path.appendSegments((Collection)segments);
        return new FSResource((FSPath)newPath);
    }

    @Override
    public FSResource appendRelativePath(String relativePath) {
        FSPath newPath = this.path.appendRelativePath(relativePath);
        return new FSResource(newPath);
    }

    @Override
    public FSResource appendOrReplaceWithPath(String other) {
        FSPath newPath = this.path.appendOrReplaceWithPath(other);
        return new FSResource(newPath);
    }

    @Override
    public FSResource appendRelativePath(ResourcePath relativePath) {
        FSPath newPath = this.path.appendRelativePath(relativePath);
        return new FSResource(newPath);
    }

    @Override
    public FSResource replaceLeaf(String segment) {
        FSPath newPath = this.path.replaceLeaf(segment);
        return new FSResource(newPath);
    }

    @Override
    public HierarchicalResourceType getType() throws IOException {
        BasicFileAttributes attributes = Files.readAttributes(this.getJavaPath(), BasicFileAttributes.class, new LinkOption[0]);
        if (attributes.isRegularFile()) {
            return HierarchicalResourceType.File;
        }
        if (attributes.isDirectory()) {
            return HierarchicalResourceType.Directory;
        }
        return HierarchicalResourceType.Unknown;
    }

    @Override
    public boolean isFile() throws IOException {
        BasicFileAttributes attributes = Files.readAttributes(this.getJavaPath(), BasicFileAttributes.class, new LinkOption[0]);
        return attributes.isRegularFile();
    }

    @Override
    public boolean isDirectory() throws IOException {
        BasicFileAttributes attributes = Files.readAttributes(this.getJavaPath(), BasicFileAttributes.class, new LinkOption[0]);
        return attributes.isDirectory();
    }

    @Override
    public boolean exists() {
        return Files.exists(this.path.javaPath, new LinkOption[0]);
    }

    @Override
    public boolean isReadable() {
        return Files.isReadable(this.path.javaPath);
    }

    @Override
    public boolean isWritable() {
        return Files.isWritable(this.path.javaPath);
    }

    @Override
    public Instant getLastModifiedTime() throws IOException {
        return Files.getLastModifiedTime(this.path.javaPath, new LinkOption[0]).toInstant();
    }

    @Override
    public void setLastModifiedTime(Instant moment) throws IOException {
        Files.setLastModifiedTime(this.path.javaPath, FileTime.from(moment));
    }

    @Override
    public long getSize() throws IOException {
        return Files.size(this.path.javaPath);
    }

    public Stream<FSResource> list() throws IOException {
        return Files.list(this.path.javaPath).map(FSResource::new);
    }

    public Stream<FSResource> list(ResourceMatcher matcher) throws IOException {
        try {
            return Files.list(this.path.javaPath).map(FSResource::new).filter(n -> {
                try {
                    return matcher.matches((HierarchicalResource)n, this);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public Stream<FSResource> walk() throws IOException {
        return Files.walk(this.path.javaPath, new FileVisitOption[0]).map(FSResource::new);
    }

    @Override
    public Stream<FSResource> walk(ResourceWalker walker, ResourceMatcher matcher, @Nullable HierarchicalResourceAccess access) throws IOException {
        Stream.Builder<FSResource> streamBuilder = Stream.builder();
        ResourceWalkerFileVisitor visitor = new ResourceWalkerFileVisitor(walker, matcher, this, streamBuilder, access);
        Files.walkFileTree(this.path.javaPath, visitor);
        return streamBuilder.build();
    }

    @Override
    public InputStream openRead() throws IOException {
        return Files.newInputStream(this.path.javaPath, StandardOpenOption.READ);
    }

    @Override
    public byte[] readBytes() throws IOException {
        return Files.readAllBytes(this.path.javaPath);
    }

    public List<String> readLines() throws IOException {
        return this.readLines(StandardCharsets.UTF_8);
    }

    public List<String> readLines(Charset fromCharset) throws IOException {
        return Files.readAllLines(this.path.javaPath, fromCharset);
    }

    @Override
    public OutputStream openWrite() throws IOException {
        return Files.newOutputStream(this.path.javaPath, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
    }

    @Override
    public OutputStream openWriteAppend() throws IOException {
        return Files.newOutputStream(this.path.javaPath, StandardOpenOption.WRITE, StandardOpenOption.APPEND, StandardOpenOption.CREATE);
    }

    @Override
    public OutputStream openWriteExisting() throws IOException {
        return Files.newOutputStream(this.path.javaPath, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    @Override
    public OutputStream openWriteNew() throws IOException {
        return Files.newOutputStream(this.path.javaPath, StandardOpenOption.CREATE_NEW);
    }

    @Override
    public void writeBytes(byte[] bytes) throws IOException {
        Files.write(this.path.javaPath, bytes, new OpenOption[0]);
    }

    public void writeLines(Iterable<String> lines) throws IOException {
        this.writeLines(lines, StandardCharsets.UTF_8);
    }

    public void writeLines(Iterable<String> lines, Charset fromCharset) throws IOException {
        Files.write(this.path.javaPath, lines, fromCharset, new OpenOption[0]);
    }

    @Override
    public void writeString(String string, Charset fromCharset) throws IOException {
        Files.write(this.path.javaPath, string.getBytes(fromCharset), new OpenOption[0]);
    }

    @Override
    public void copyTo(HierarchicalResource other) throws IOException {
        if (!(other instanceof FSResource)) {
            throw new ResourceRuntimeException("Cannot copy to '" + other + "', it is not an FSResource");
        }
        this.copyTo((FSResource)other);
    }

    public void copyTo(FSResource other) throws IOException {
        Files.copy(this.path.javaPath, other.path.javaPath, StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    public void copyRecursivelyTo(HierarchicalResource other) throws IOException {
        if (!(other instanceof FSResource)) {
            throw new ResourceRuntimeException("Cannot copy recursively to '" + other + "', it is not an FSResource");
        }
        this.copyRecursivelyTo((FSResource)other);
    }

    public void copyRecursivelyTo(FSResource other) throws IOException {
        try (Stream<Path> stream = Files.walk(this.path.javaPath, new FileVisitOption[0]);){
            stream.forEachOrdered(sourcePath -> {
                try {
                    Files.copy(sourcePath, this.path.javaPath.resolve(other.path.javaPath.relativize((Path)sourcePath)), new CopyOption[0]);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    @Override
    public void moveTo(HierarchicalResource other) throws IOException {
        if (!(other instanceof FSResource)) {
            throw new ResourceRuntimeException("Cannot move to '" + other + "', it is not an FSResource");
        }
        this.moveTo((FSResource)other);
    }

    public void moveTo(FSResource other) throws IOException {
        Files.move(this.path.javaPath, other.path.javaPath, StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    public FSResource createFile(boolean createParents) throws IOException {
        if (createParents) {
            this.createParents();
        }
        Files.createFile(this.path.javaPath, new FileAttribute[0]);
        return this;
    }

    @Override
    public FSResource createDirectory(boolean createParents) throws IOException {
        if (createParents) {
            this.createParents();
        }
        Files.createDirectory(this.path.javaPath, new FileAttribute[0]);
        return this;
    }

    @Override
    public FSResource ensureDirectoryExists() throws IOException {
        Files.createDirectories(this.path.javaPath, new FileAttribute[0]);
        return this;
    }

    @Override
    public FSResource createParents() throws IOException {
        @Nullable FSResource parent = this.getParent();
        if (parent == null) {
            return this;
        }
        Files.createDirectories(parent.path.javaPath, new FileAttribute[0]);
        return this;
    }

    @Override
    public void delete(boolean deleteRecursively) throws IOException {
        if (deleteRecursively) {
            try {
                if (!Files.exists(this.path.javaPath, new LinkOption[0])) {
                    return;
                }
                Files.walk(this.path.javaPath, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(path -> {
                    try {
                        Files.deleteIfExists(path);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
            }
            catch (UncheckedIOException e) {
                throw e.getCause();
            }
        } else {
            Files.deleteIfExists(this.path.javaPath);
        }
    }

    @Override
    protected FSResource self() {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FSResource that = (FSResource)o;
        return this.path.equals(that.path);
    }
}

