/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.fs;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.stream.Stream;
import mb.resource.fs.FSResource;
import mb.resource.hierarchical.HierarchicalResourceAccess;
import mb.resource.hierarchical.match.ResourceMatcher;
import mb.resource.hierarchical.walk.ResourceWalker;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class ResourceWalkerFileVisitor
implements FileVisitor<Path> {
    private final ResourceMatcher matcher;
    private final ResourceWalker walker;
    private final FSResource rootDirectory;
    private final Stream.Builder<FSResource> streamBuilder;
    private final @Nullable HierarchicalResourceAccess access;

    ResourceWalkerFileVisitor(ResourceWalker walker, ResourceMatcher matcher, FSResource rootDirectory, Stream.Builder<FSResource> streamBuilder, @Nullable HierarchicalResourceAccess access) {
        this.matcher = matcher;
        this.walker = walker;
        this.rootDirectory = rootDirectory;
        this.streamBuilder = streamBuilder;
        this.access = access;
    }

    @Override
    public FileVisitResult preVisitDirectory(@NonNull Path dir, @NonNull BasicFileAttributes attrs) throws IOException {
        FSResource resource = new FSResource(dir);
        if (this.access != null) {
            this.access.read(resource);
        }
        if (this.matcher.matches(resource, this.rootDirectory)) {
            this.streamBuilder.add(resource);
        }
        if (this.walker.traverse(resource, this.rootDirectory)) {
            return FileVisitResult.CONTINUE;
        }
        return FileVisitResult.SKIP_SUBTREE;
    }

    @Override
    public FileVisitResult visitFile(@NonNull Path file, @NonNull BasicFileAttributes attrs) throws IOException {
        FSResource resource = new FSResource(file);
        if (this.access != null) {
            this.access.read(resource);
        }
        if (this.matcher.matches(resource, this.rootDirectory)) {
            this.streamBuilder.add(resource);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(@NonNull Path file, @NonNull IOException exc) {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(@NonNull Path dir, @Nullable IOException exc) {
        return FileVisitResult.CONTINUE;
    }
}

