/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.hierarchical;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import mb.resource.WritableResource;
import mb.resource.hierarchical.HierarchicalResourceAccess;
import mb.resource.hierarchical.HierarchicalResourceType;
import mb.resource.hierarchical.ResourcePath;
import mb.resource.hierarchical.match.ResourceMatcher;
import mb.resource.hierarchical.walk.ResourceWalker;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface HierarchicalResource
extends WritableResource {
    default public ResourcePath getPath() {
        return this.getKey();
    }

    @Override
    public ResourcePath getKey();

    public @Nullable HierarchicalResource getParent();

    public @Nullable HierarchicalResource getRoot();

    default public @Nullable String getLeaf() {
        return this.getPath().getLeaf();
    }

    default public @Nullable String getLeafExtension() {
        return this.getPath().getLeafExtension();
    }

    public HierarchicalResource appendSegment(String var1);

    public HierarchicalResource appendSegments(Iterable<String> var1);

    public HierarchicalResource appendSegments(Collection<String> var1);

    public HierarchicalResource appendSegments(List<String> var1);

    public HierarchicalResource appendSegments(String ... var1);

    public HierarchicalResource appendRelativePath(String var1);

    public HierarchicalResource appendOrReplaceWithPath(String var1);

    public HierarchicalResource appendRelativePath(ResourcePath var1);

    public HierarchicalResource appendOrReplaceWithPath(ResourcePath var1);

    public HierarchicalResource replaceLeaf(String var1);

    public HierarchicalResource appendToLeaf(String var1);

    public HierarchicalResource applyToLeaf(Function<String, String> var1);

    public HierarchicalResource replaceLeafExtension(String var1);

    public HierarchicalResource ensureLeafExtension(String var1);

    public HierarchicalResource appendExtensionToLeaf(String var1);

    public HierarchicalResource applyToLeafExtension(Function<String, String> var1);

    public HierarchicalResourceType getType() throws IOException;

    default public boolean isFile() throws IOException {
        return this.getType() == HierarchicalResourceType.File;
    }

    default public boolean isDirectory() throws IOException {
        return this.getType() == HierarchicalResourceType.Directory;
    }

    public Stream<? extends HierarchicalResource> list() throws IOException;

    public Stream<? extends HierarchicalResource> list(ResourceMatcher var1) throws IOException;

    public Stream<? extends HierarchicalResource> walk() throws IOException;

    public Stream<? extends HierarchicalResource> walk(ResourceWalker var1, ResourceMatcher var2) throws IOException;

    public Stream<? extends HierarchicalResource> walk(ResourceWalker var1, ResourceMatcher var2, @Nullable HierarchicalResourceAccess var3) throws IOException;

    public void copyTo(HierarchicalResource var1) throws IOException;

    public void copyRecursivelyTo(HierarchicalResource var1) throws IOException;

    public void moveTo(HierarchicalResource var1) throws IOException;

    @Override
    default public OutputStream openWrite() throws IOException {
        this.ensureFileExists();
        return this.openWriteExisting();
    }

    @Override
    default public OutputStream openWriteNew() throws IOException {
        this.createFile();
        return this.openWriteExisting();
    }

    public HierarchicalResource createFile(boolean var1) throws IOException;

    public HierarchicalResource createFile() throws IOException;

    public HierarchicalResource ensureFileExists() throws IOException;

    public HierarchicalResource createDirectory(boolean var1) throws IOException;

    public HierarchicalResource createDirectory() throws IOException;

    public HierarchicalResource ensureDirectoryExists() throws IOException;

    public HierarchicalResource createParents() throws IOException;

    public void delete(boolean var1) throws IOException;

    default public void delete() throws IOException {
        this.delete(false);
    }
}

