/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.hierarchical;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import mb.resource.hierarchical.DirectoryAlreadyExistsException;
import mb.resource.hierarchical.FilenameExtensionUtil;
import mb.resource.hierarchical.HierarchicalResource;
import mb.resource.hierarchical.HierarchicalResourceAccess;
import mb.resource.hierarchical.ResourcePath;
import mb.resource.hierarchical.match.ResourceMatcher;
import mb.resource.hierarchical.walk.ResourceWalker;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class HierarchicalResourceDefaults<SELF extends HierarchicalResourceDefaults<SELF>>
implements HierarchicalResource {
    protected abstract SELF self();

    public abstract SELF appendSegments(Iterable<String> var1);

    public SELF appendSegments(Collection<String> segments) {
        return (SELF)this.appendSegments((Iterable)segments);
    }

    public SELF appendSegments(List<String> segments) {
        return (SELF)this.appendSegments((Collection)segments);
    }

    public SELF appendSegments(String ... segments) {
        return (SELF)this.appendSegments((List)Arrays.asList(segments));
    }

    public abstract SELF appendRelativePath(ResourcePath var1);

    public SELF appendOrReplaceWithPath(ResourcePath other) {
        if (other.isAbsolute()) {
            HierarchicalResourceDefaults otherSelf = (HierarchicalResourceDefaults)((Object)other);
            return (SELF)otherSelf;
        }
        return (SELF)this.appendRelativePath(other);
    }

    public abstract SELF replaceLeaf(String var1);

    public SELF appendToLeaf(String segment) {
        @Nullable String leaf = this.getLeaf();
        if (leaf == null) {
            return this.self();
        }
        return (SELF)this.replaceLeaf(leaf + segment);
    }

    public SELF applyToLeaf(Function<String, String> func) {
        @Nullable String leaf = this.getLeaf();
        if (leaf == null) {
            return this.self();
        }
        return (SELF)this.replaceLeaf(func.apply(leaf));
    }

    public SELF replaceLeafExtension(String extension) {
        @Nullable String leaf = this.getLeaf();
        if (leaf == null) {
            return this.self();
        }
        return (SELF)this.replaceLeaf(FilenameExtensionUtil.replaceExtension(leaf, extension));
    }

    public SELF ensureLeafExtension(String extension) {
        @Nullable String leaf = this.getLeaf();
        if (leaf == null) {
            return this.self();
        }
        return (SELF)this.replaceLeaf(FilenameExtensionUtil.ensureExtension(leaf, extension));
    }

    public SELF appendExtensionToLeaf(String extension) {
        @Nullable String leaf = this.getLeaf();
        if (leaf == null) {
            return this.self();
        }
        return (SELF)this.replaceLeaf(FilenameExtensionUtil.appendExtension(leaf, extension));
    }

    public SELF applyToLeafExtension(Function<String, String> func) {
        @Nullable String leaf = this.getLeaf();
        if (leaf == null) {
            return this.self();
        }
        return (SELF)this.replaceLeaf(FilenameExtensionUtil.applyToExtension(leaf, func));
    }

    public abstract Stream<? extends SELF> walk(ResourceWalker var1, ResourceMatcher var2, @Nullable HierarchicalResourceAccess var3) throws IOException;

    public Stream<? extends SELF> walk(ResourceWalker walker, ResourceMatcher matcher) throws IOException {
        return this.walk(walker, matcher, null);
    }

    public abstract SELF createFile(boolean var1) throws IOException;

    public SELF createFile() throws IOException {
        return (SELF)this.createFile(false);
    }

    public SELF ensureFileExists() throws IOException {
        try {
            return (SELF)this.createFile(true);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            return this.self();
        }
    }

    public abstract SELF createDirectory(boolean var1) throws IOException;

    public SELF createDirectory() throws IOException {
        return (SELF)this.createDirectory(false);
    }

    public SELF ensureDirectoryExists() throws IOException {
        try {
            return (SELF)this.createDirectory(true);
        }
        catch (DirectoryAlreadyExistsException directoryAlreadyExistsException) {
            return this.self();
        }
    }

    @Override
    public abstract boolean equals(@Nullable Object var1);

    @Override
    public int hashCode() {
        return this.getPath().hashCode();
    }

    @Override
    public String toString() {
        return this.getPath().toString();
    }
}

