/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.hierarchical;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import mb.resource.ResourceKey;
import mb.resource.hierarchical.FilenameExtensionUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface ResourcePath
extends ResourceKey {
    public boolean isAbsolute();

    public int getSegmentCount();

    public Iterable<String> getSegments();

    public @Nullable ResourcePath getParent();

    public @Nullable ResourcePath getRoot();

    public @Nullable String getLeaf();

    default public @Nullable String getLeafExtension() {
        @Nullable String leaf = this.getLeaf();
        if (leaf != null) {
            return FilenameExtensionUtil.getExtension(leaf);
        }
        return null;
    }

    public ResourcePath getNormalized();

    public ResourcePath relativize(ResourcePath var1);

    public String relativizeToString(ResourcePath var1);

    public ResourcePath appendSegment(String var1);

    public ResourcePath appendSegments(Iterable<String> var1);

    public ResourcePath appendSegments(Collection<String> var1);

    public ResourcePath appendSegments(List<String> var1);

    public ResourcePath appendSegments(String ... var1);

    public ResourcePath appendRelativePath(String var1);

    public ResourcePath appendOrReplaceWithPath(String var1);

    public ResourcePath appendString(String var1);

    public ResourcePath appendRelativePath(ResourcePath var1);

    public ResourcePath appendOrReplaceWithPath(ResourcePath var1);

    public ResourcePath replaceLeaf(String var1);

    public ResourcePath appendToLeaf(String var1);

    public ResourcePath applyToLeaf(Function<String, String> var1);

    public ResourcePath replaceLeafExtension(String var1);

    public ResourcePath ensureLeafExtension(String var1);

    public ResourcePath appendExtensionToLeaf(String var1);

    public ResourcePath applyToLeafExtension(Function<String, String> var1);

    @Override
    public String toString();
}

