/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.hierarchical.match.path;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import mb.resource.hierarchical.ResourcePath;
import mb.resource.hierarchical.match.path.PathMatcher;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ExtensionsPathMatcher
implements PathMatcher {
    private final List<String> extensions;
    private transient HashSet<String> extensionsHashSet;

    public ExtensionsPathMatcher(HashSet<String> extensions) {
        this.extensions = new ArrayList<String>(extensions);
        this.extensionsHashSet = extensions;
    }

    public ExtensionsPathMatcher(ArrayList<String> extensions) {
        this.extensions = extensions;
        this.extensionsHashSet = new HashSet<String>(extensions);
    }

    public ExtensionsPathMatcher(Collection<String> extensions) {
        this.extensions = new ArrayList<String>(extensions);
        this.extensionsHashSet = new HashSet<String>(extensions);
    }

    public ExtensionsPathMatcher(String ... extensions) {
        this.extensions = Arrays.asList(extensions);
        this.extensionsHashSet = new HashSet<String>(this.extensions);
    }

    @Override
    public boolean matches(ResourcePath path, ResourcePath rootDir) {
        @Nullable String extension = path.getLeafExtension();
        if (extension == null) {
            return false;
        }
        return this.extensionsHashSet.contains(extension);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtensionsPathMatcher that = (ExtensionsPathMatcher)o;
        return this.extensions.equals(that.extensions);
    }

    public int hashCode() {
        return this.extensions.hashCode();
    }

    public String toString() {
        return "ExtensionsPathMatcher(" + this.extensions + ")";
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.extensionsHashSet = new HashSet<String>(this.extensions);
    }
}

