/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.hierarchical.match.path;

import java.util.ArrayList;
import mb.resource.hierarchical.ResourcePath;
import mb.resource.hierarchical.match.path.AntPattern;
import mb.resource.hierarchical.match.path.PathMatcher;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PatternsPathMatcher
implements PathMatcher {
    private final ArrayList<AntPattern> patterns = new ArrayList();

    public PatternsPathMatcher(Iterable<String> patterns) {
        for (String pattern : patterns) {
            this.patterns.add(new AntPattern(pattern));
        }
    }

    @Override
    public boolean matches(ResourcePath path, ResourcePath rootDir) {
        String relative = rootDir.relativize(path).toString();
        for (AntPattern pattern : this.patterns) {
            if (!pattern.match(relative)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatternsPathMatcher that = (PatternsPathMatcher)o;
        return this.patterns.equals(that.patterns);
    }

    public int hashCode() {
        return this.patterns.hashCode();
    }

    public String toString() {
        return "PatternsPathMatcher(" + this.patterns + ")";
    }
}

