/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.text;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import mb.resource.DefaultResourceKey;
import mb.resource.ReadableResource;

public class TextResource
implements ReadableResource,
Serializable {
    public final String text;
    public final DefaultResourceKey key;

    TextResource(String text, String id) {
        this.text = text;
        this.key = new DefaultResourceKey("text", id);
    }

    @Override
    public void close() {
    }

    @Override
    public DefaultResourceKey getKey() {
        return this.key;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public Instant getLastModifiedTime() {
        return Instant.EPOCH;
    }

    @Override
    public long getSize() {
        return this.text.length() * 2;
    }

    @Override
    public InputStream openRead() {
        return new ByteArrayInputStream(this.readBytes());
    }

    @Override
    public byte[] readBytes() {
        return this.text.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public String readString(Charset fromCharset) {
        return this.text;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextResource that = (TextResource)o;
        return this.key.equals(that.key);
    }

    @Override
    public int hashCode() {
        return this.key.hashCode();
    }

    @Override
    public String toString() {
        return this.key.toString();
    }
}

