/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.url;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.time.Instant;
import java.util.Collection;
import java.util.stream.Stream;
import mb.resource.hierarchical.HierarchicalResource;
import mb.resource.hierarchical.HierarchicalResourceAccess;
import mb.resource.hierarchical.HierarchicalResourceDefaults;
import mb.resource.hierarchical.HierarchicalResourceType;
import mb.resource.hierarchical.ResourcePath;
import mb.resource.hierarchical.match.ResourceMatcher;
import mb.resource.hierarchical.walk.ResourceWalker;
import mb.resource.url.URLPath;
import org.checkerframework.checker.nullness.qual.Nullable;

public class URLResource
extends HierarchicalResourceDefaults<URLResource>
implements HierarchicalResource {
    private final URLPath path;

    public URLResource(URLPath path) {
        this.path = path;
    }

    public URLResource(URL url) {
        this.path = new URLPath(url);
    }

    @Override
    public void close() {
    }

    @Override
    public URLPath getKey() {
        return this.path;
    }

    public URI getURI() {
        return this.path.getURI();
    }

    public URL getURL() throws MalformedURLException {
        return this.path.getURL();
    }

    @Override
    public @Nullable URLResource getParent() {
        @Nullable URLPath newPath = this.path.getParent();
        if (newPath == null) {
            return null;
        }
        return new URLResource(newPath);
    }

    @Override
    public @Nullable URLResource getRoot() {
        @Nullable URLPath newPath = this.path.getRoot();
        if (newPath == null) {
            return null;
        }
        return new URLResource(newPath);
    }

    @Override
    public URLResource appendSegment(String segment) {
        return new URLResource(this.path.appendSegment(segment));
    }

    @Override
    public URLResource appendSegments(Iterable<String> segments) {
        return new URLResource((URLPath)this.path.appendSegments((Iterable)segments));
    }

    @Override
    public URLResource appendSegments(Collection<String> segments) {
        return new URLResource((URLPath)this.path.appendSegments((Collection)segments));
    }

    @Override
    public URLResource appendRelativePath(String relativePath) {
        return new URLResource(this.path.appendRelativePath(relativePath));
    }

    @Override
    public URLResource appendOrReplaceWithPath(String other) {
        return new URLResource(this.path.appendOrReplaceWithPath(other));
    }

    @Override
    public URLResource appendRelativePath(ResourcePath relativePath) {
        return new URLResource(this.path.appendRelativePath(relativePath));
    }

    @Override
    public URLResource replaceLeaf(String segment) {
        return new URLResource(this.path.replaceLeaf(segment));
    }

    @Override
    public HierarchicalResourceType getType() throws IOException {
        throw new UnsupportedOperationException("URL resources do not support resource types");
    }

    @Override
    public boolean isFile() throws IOException {
        return false;
    }

    @Override
    public boolean isDirectory() throws IOException {
        return false;
    }

    public Stream<? extends URLResource> list() throws IOException {
        throw new UnsupportedOperationException("URL resources do not support listing");
    }

    public Stream<? extends URLResource> list(ResourceMatcher matcher) throws IOException {
        throw new UnsupportedOperationException("URL resources do not support listing");
    }

    public Stream<? extends URLResource> walk() throws IOException {
        throw new UnsupportedOperationException("URL resources do not support walking");
    }

    @Override
    public Stream<? extends URLResource> walk(ResourceWalker walker, ResourceMatcher matcher) throws IOException {
        throw new UnsupportedOperationException("URL resources do not support walking");
    }

    @Override
    public Stream<? extends URLResource> walk(ResourceWalker walker, ResourceMatcher matcher, @Nullable HierarchicalResourceAccess access) throws IOException {
        throw new UnsupportedOperationException("URL resources do not support walking");
    }

    @Override
    public void copyTo(HierarchicalResource other) throws IOException {
        throw new UnsupportedOperationException("URL resources do not support copying");
    }

    @Override
    public void copyRecursivelyTo(HierarchicalResource other) throws IOException {
        throw new UnsupportedOperationException("URL resources do not support copying");
    }

    @Override
    public void moveTo(HierarchicalResource other) throws IOException {
        throw new UnsupportedOperationException("URL resources do not support moving");
    }

    @Override
    public URLResource createFile(boolean createParents) throws IOException {
        throw new UnsupportedOperationException("URL resources do not support creating files");
    }

    @Override
    public URLResource createDirectory(boolean createParents) throws IOException {
        throw new UnsupportedOperationException("URL resources do not support creating directories");
    }

    @Override
    public URLResource createParents() throws IOException {
        throw new UnsupportedOperationException("URL resources do not support creating directories");
    }

    @Override
    public void delete(boolean deleteRecursively) throws IOException {
        throw new UnsupportedOperationException("URL resources do not support deletion");
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public Instant getLastModifiedTime() throws IOException {
        return Instant.ofEpochMilli(this.openConnection().getLastModified());
    }

    @Override
    public long getSize() throws IOException {
        return this.openConnection().getContentLengthLong();
    }

    @Override
    public InputStream openRead() throws IOException {
        return this.openConnection().getInputStream();
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public void setLastModifiedTime(Instant moment) throws IOException {
    }

    @Override
    public OutputStream openWriteExisting() throws IOException {
        URLConnection connection = this.openConnection();
        connection.setDoOutput(true);
        return connection.getOutputStream();
    }

    @Override
    public OutputStream openWriteAppend() throws IOException {
        throw new UnsupportedOperationException("URL resources do not support opening an appending output stream");
    }

    private URLConnection openConnection() throws IOException {
        return this.getURL().openConnection();
    }

    @Override
    protected URLResource self() {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        URLResource that = (URLResource)o;
        return this.path.equals(that.path);
    }
}

