/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.url;

import java.io.Serializable;
import java.net.URISyntaxException;
import mb.resource.QualifiedResourceKeyString;
import mb.resource.ResourceKeyString;
import mb.resource.ResourceRegistry;
import mb.resource.ResourceRuntimeException;
import mb.resource.url.URLPath;
import mb.resource.url.URLResource;

public class URLResourceRegistry
implements ResourceRegistry {
    public static final String qualifier = "url";

    @Override
    public String qualifier() {
        return qualifier;
    }

    @Override
    public URLResource getResource(Serializable id) {
        if (!(id instanceof URLPath)) {
            throw new ResourceRuntimeException("Cannot get URL resource with ID '" + id + "'; the ID is not of type URLPath");
        }
        URLPath urlPath = (URLPath)id;
        return new URLResource(urlPath);
    }

    @Override
    public URLPath getResourceKey(ResourceKeyString keyStr) {
        if (!keyStr.qualifierMatchesOrMissing(qualifier)) {
            throw new ResourceRuntimeException("Qualifier of '" + keyStr + "' does not match qualifier '" + qualifier + "' of this resource registry");
        }
        try {
            return new URLPath(keyStr.getId());
        }
        catch (URISyntaxException e) {
            throw new ResourceRuntimeException("Cannot get URL path with identifier string representation '" + keyStr + "'; the string representation cannot be parsed into an URI", e);
        }
    }

    @Override
    public URLResource getResource(ResourceKeyString keyStr) {
        if (!keyStr.qualifierMatchesOrMissing(qualifier)) {
            throw new ResourceRuntimeException("Qualifier of '" + keyStr + "' does not match qualifier '" + qualifier + "' of this resource registry");
        }
        try {
            URLPath urlPath = new URLPath(keyStr.getId());
            return new URLResource(urlPath);
        }
        catch (URISyntaxException e) {
            throw new ResourceRuntimeException("Cannot get URL resource with identifier string representation '" + keyStr + "'; the string representation cannot be parsed into an URI", e);
        }
    }

    @Override
    public QualifiedResourceKeyString toResourceKeyString(Serializable id) {
        if (!(id instanceof URLPath)) {
            throw new ResourceRuntimeException("Cannot convert identifier '" + id + "' to its string representation; it is not of type URLPath");
        }
        URLPath urlPath = (URLPath)id;
        return QualifiedResourceKeyString.of(this.qualifier(), urlPath.toString());
    }

    @Override
    public String toString(Serializable id) {
        if (!(id instanceof URLPath)) {
            throw new ResourceRuntimeException("Cannot convert identifier '" + id + "' to its string representation; it is not of type URLPath");
        }
        URLPath urlPath = (URLPath)id;
        return QualifiedResourceKeyString.toString(this.qualifier(), urlPath.toString());
    }
}

