/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.arithmetic;

import com.google.common.collect.Multiset;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.unification.ud.IUniDisunifier;
import mb.nabl2.util.TermFormatter;
import mb.statix.arithmetic.ArithExpr;
import mb.statix.solver.Delay;

class TermExpr
implements ArithExpr,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ITerm term;

    public TermExpr(ITerm term) {
        this.term = term;
    }

    @Override
    public int eval(IUniDisunifier unifier) throws Delay {
        return TermMatch.M.integerValue().match(this.term, unifier).orElseThrow(() -> Delay.ofVars(unifier.getVars(this.term)));
    }

    @Override
    public ArithExpr apply(ISubstitution.Immutable subst) {
        return new TermExpr(subst.apply(this.term));
    }

    @Override
    public ArithExpr apply(IRenaming subst) {
        return new TermExpr(subst.apply(this.term));
    }

    @Override
    public Optional<ITerm> isTerm() {
        return Optional.of(this.term);
    }

    @Override
    public Multiset<ITermVar> getVars() {
        return this.term.getVars();
    }

    @Override
    public String toString(TermFormatter termToString) {
        return termToString.format(this.term);
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TermExpr termExpr = (TermExpr)o;
        return Objects.equals(this.term, termExpr.term);
    }

    public int hashCode() {
        return Objects.hash(this.term);
    }
}

