/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.constraints;

import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.TermFormatter;
import mb.statix.arithmetic.ArithExpr;
import mb.statix.arithmetic.ArithTest;
import mb.statix.constraints.messages.IMessage;
import mb.statix.solver.IConstraint;

public class CArith
implements IConstraint,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ArithExpr expr1;
    private final ArithTest op;
    private final ArithExpr expr2;
    @Nullable
    private final IConstraint cause;
    @Nullable
    private final IMessage message;

    public CArith(ArithExpr expr1, ArithTest op, ArithExpr expr2) {
        this(expr1, op, expr2, null, null);
    }

    public CArith(ArithExpr expr1, ArithTest op, ArithExpr expr2, @Nullable IMessage message) {
        this(expr1, op, expr2, null, message);
    }

    private CArith(ArithExpr expr1, ArithTest op, ArithExpr expr2, @Nullable IConstraint cause, @Nullable IMessage message) {
        this.expr1 = expr1;
        this.op = op;
        this.expr2 = expr2;
        this.cause = cause;
        this.message = message;
    }

    public ArithExpr expr1() {
        return this.expr1;
    }

    public ArithTest op() {
        return this.op;
    }

    public ArithExpr expr2() {
        return this.expr2;
    }

    @Override
    public Optional<IConstraint> cause() {
        return Optional.ofNullable(this.cause);
    }

    @Override
    public CArith withCause(@Nullable IConstraint cause) {
        return new CArith(this.expr1, this.op, this.expr2, cause, this.message);
    }

    @Override
    public Optional<IMessage> message() {
        return Optional.ofNullable(this.message);
    }

    @Override
    public CArith withMessage(@Nullable IMessage message) {
        return new CArith(this.expr1, this.op, this.expr2, this.cause, message);
    }

    @Override
    public <R> R match(IConstraint.Cases<R> cases) {
        return cases.caseArith(this);
    }

    @Override
    public <R, E extends Throwable> R matchOrThrow(IConstraint.CheckedCases<R, E> cases) throws E {
        return cases.caseArith(this);
    }

    @Override
    public Multiset<ITermVar> getVars() {
        ImmutableMultiset.Builder vars = ImmutableMultiset.builder();
        vars.addAll(this.expr1.getVars());
        vars.addAll(this.expr2.getVars());
        return vars.build();
    }

    @Override
    public CArith apply(ISubstitution.Immutable subst) {
        return new CArith(this.expr1.apply(subst), this.op, this.expr2.apply(subst), this.cause, this.message == null ? null : this.message.apply(subst));
    }

    @Override
    public CArith apply(IRenaming subst) {
        return new CArith(this.expr1.apply(subst), this.op, this.expr2.apply(subst), this.cause, this.message == null ? null : this.message.apply(subst));
    }

    @Override
    public String toString(TermFormatter termToString) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.expr1.toString(termToString));
        sb.append(" #").append(this.op).append(" ");
        sb.append(this.expr2.toString(termToString));
        return sb.toString();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CArith cArith = (CArith)o;
        return Objects.equals(this.expr1, cArith.expr1) && Objects.equals(this.op, cArith.op) && Objects.equals(this.expr2, cArith.expr2) && Objects.equals(this.cause, cArith.cause) && Objects.equals(this.message, cArith.message);
    }

    public int hashCode() {
        return Objects.hash(this.expr1, this.op, this.expr2, this.cause, this.message);
    }
}

