/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.constraints;

import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.TermFormatter;
import mb.statix.solver.IConstraint;

public class CAstId
implements IConstraint,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ITerm term;
    private final ITerm idTerm;
    @Nullable
    private final IConstraint cause;

    public CAstId(ITerm term, ITerm idTerm) {
        this(term, idTerm, null);
    }

    public CAstId(ITerm term, ITerm idTerm, @Nullable IConstraint cause) {
        this.term = term;
        this.idTerm = idTerm;
        this.cause = cause;
    }

    public ITerm astTerm() {
        return this.term;
    }

    public ITerm idTerm() {
        return this.idTerm;
    }

    @Override
    public Optional<IConstraint> cause() {
        return Optional.ofNullable(this.cause);
    }

    @Override
    public CAstId withCause(@Nullable IConstraint cause) {
        return new CAstId(this.term, this.idTerm, cause);
    }

    @Override
    public <R> R match(IConstraint.Cases<R> cases) {
        return cases.caseTermId(this);
    }

    @Override
    public <R, E extends Throwable> R matchOrThrow(IConstraint.CheckedCases<R, E> cases) throws E {
        return cases.caseTermId(this);
    }

    @Override
    public Multiset<ITermVar> getVars() {
        ImmutableMultiset.Builder vars = ImmutableMultiset.builder();
        vars.addAll(this.term.getVars());
        vars.addAll(this.idTerm.getVars());
        return vars.build();
    }

    @Override
    public CAstId apply(ISubstitution.Immutable subst) {
        return new CAstId(subst.apply(this.term), subst.apply(this.idTerm), this.cause);
    }

    @Override
    public CAstId apply(IRenaming subst) {
        return new CAstId(subst.apply(this.term), subst.apply(this.idTerm), this.cause);
    }

    @Override
    public String toString(TermFormatter termToString) {
        StringBuilder sb = new StringBuilder();
        sb.append("termId(");
        sb.append(termToString.format(this.term));
        sb.append(", ");
        sb.append(termToString.format(this.idTerm));
        sb.append(")");
        return sb.toString();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CAstId cAstId = (CAstId)o;
        return Objects.equals(this.term, cAstId.term) && Objects.equals(this.idTerm, cAstId.idTerm) && Objects.equals(this.cause, cAstId.cause);
    }

    public int hashCode() {
        return Objects.hash(this.term, this.idTerm, this.cause);
    }
}

