/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.constraints;

import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.TermFormatter;
import mb.statix.solver.IConstraint;

public class CAstProperty
implements IConstraint,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ITerm idTerm;
    private final ITerm property;
    private final Op op;
    private final ITerm value;
    @Nullable
    private final IConstraint cause;

    public CAstProperty(ITerm idTerm, ITerm property, Op op, ITerm value) {
        this(idTerm, property, op, value, null);
    }

    public CAstProperty(ITerm idTerm, ITerm property, Op op, ITerm value, @Nullable IConstraint cause) {
        this.idTerm = idTerm;
        this.property = property;
        this.op = op;
        this.value = value;
        this.cause = cause;
    }

    public ITerm idTerm() {
        return this.idTerm;
    }

    public ITerm property() {
        return this.property;
    }

    public Op op() {
        return this.op;
    }

    public ITerm value() {
        return this.value;
    }

    @Override
    public Optional<IConstraint> cause() {
        return Optional.ofNullable(this.cause);
    }

    @Override
    public CAstProperty withCause(@Nullable IConstraint cause) {
        return new CAstProperty(this.idTerm, this.property, this.op, this.value, cause);
    }

    @Override
    public <R> R match(IConstraint.Cases<R> cases) {
        return cases.caseTermProperty(this);
    }

    @Override
    public <R, E extends Throwable> R matchOrThrow(IConstraint.CheckedCases<R, E> cases) throws E {
        return cases.caseTermProperty(this);
    }

    @Override
    public Multiset<ITermVar> getVars() {
        ImmutableMultiset.Builder vars = ImmutableMultiset.builder();
        vars.addAll(this.idTerm.getVars());
        vars.addAll(this.value.getVars());
        return vars.build();
    }

    @Override
    public CAstProperty apply(ISubstitution.Immutable subst) {
        return new CAstProperty(subst.apply(this.idTerm), this.property, this.op, subst.apply(this.value), this.cause);
    }

    @Override
    public CAstProperty apply(IRenaming subst) {
        return new CAstProperty(subst.apply(this.idTerm), this.property, this.op, subst.apply(this.value), this.cause);
    }

    @Override
    public String toString(TermFormatter termToString) {
        StringBuilder sb = new StringBuilder();
        sb.append("@");
        sb.append(termToString.format(this.idTerm));
        sb.append(".");
        sb.append(this.property.toString());
        sb.append(" ").append((Object)this.op).append(" ");
        sb.append(termToString.format(this.value));
        return sb.toString();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CAstProperty that = (CAstProperty)o;
        return Objects.equals(this.idTerm, that.idTerm) && Objects.equals(this.property, that.property) && this.op == that.op && Objects.equals(this.value, that.value) && Objects.equals(this.cause, that.cause);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.idTerm, this.property, this.op, this.value, this.cause});
    }

    public static enum Op {
        SET{

            public String toString() {
                return ":=";
            }
        }
        ,
        ADD{

            public String toString() {
                return "+=";
            }
        };

    }
}

