/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.constraints;

import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.TermFormatter;
import mb.statix.solver.IConstraint;

public class CConj
implements IConstraint,
Serializable {
    private static final long serialVersionUID = 1L;
    private final IConstraint left;
    private final IConstraint right;
    @Nullable
    private final IConstraint cause;

    public CConj(IConstraint left, IConstraint right) {
        this(left, right, null);
    }

    public CConj(IConstraint left, IConstraint right, @Nullable IConstraint cause) {
        this.left = left;
        this.right = right;
        this.cause = cause;
    }

    public IConstraint left() {
        return this.left;
    }

    public IConstraint right() {
        return this.right;
    }

    @Override
    public Optional<IConstraint> cause() {
        return Optional.ofNullable(this.cause);
    }

    @Override
    public CConj withCause(@Nullable IConstraint cause) {
        return new CConj(this.left, this.right, cause);
    }

    @Override
    public <R> R match(IConstraint.Cases<R> cases) {
        return cases.caseConj(this);
    }

    @Override
    public <R, E extends Throwable> R matchOrThrow(IConstraint.CheckedCases<R, E> cases) throws E {
        return cases.caseConj(this);
    }

    @Override
    public Multiset<ITermVar> getVars() {
        ImmutableMultiset.Builder vars = ImmutableMultiset.builder();
        vars.addAll(this.left.getVars());
        vars.addAll(this.right.getVars());
        return vars.build();
    }

    @Override
    public CConj apply(ISubstitution.Immutable subst) {
        return new CConj(this.left.apply(subst), this.right.apply(subst), this.cause);
    }

    @Override
    public CConj apply(IRenaming subst) {
        return new CConj(this.left.apply(subst), this.right.apply(subst), this.cause);
    }

    @Override
    public String toString(TermFormatter termToString) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.left.toString(termToString));
        sb.append(", ");
        sb.append(this.right.toString(termToString));
        return sb.toString();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CConj cConj = (CConj)o;
        return Objects.equals(this.left, cConj.left) && Objects.equals(this.right, cConj.right) && Objects.equals(this.cause, cConj.cause);
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right, this.cause);
    }
}

