/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.constraints;

import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.TermFormatter;
import mb.statix.solver.IConstraint;

public class CExists
implements IConstraint,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Set<ITermVar> vars;
    private final IConstraint constraint;
    @Nullable
    private final IConstraint cause;

    public CExists(Iterable<ITermVar> vars, IConstraint constraint) {
        this(vars, constraint, null);
    }

    public CExists(Iterable<ITermVar> vars, IConstraint constraint, @Nullable IConstraint cause) {
        this.vars = ImmutableSet.copyOf(vars);
        this.constraint = constraint;
        this.cause = cause;
    }

    public Set<ITermVar> vars() {
        return this.vars;
    }

    public IConstraint constraint() {
        return this.constraint;
    }

    @Override
    public Optional<IConstraint> cause() {
        return Optional.ofNullable(this.cause);
    }

    @Override
    public CExists withCause(@Nullable IConstraint cause) {
        return new CExists(this.vars, this.constraint, cause);
    }

    @Override
    public <R> R match(IConstraint.Cases<R> cases) {
        return cases.caseExists(this);
    }

    @Override
    public <R, E extends Throwable> R matchOrThrow(IConstraint.CheckedCases<R, E> cases) throws E {
        return cases.caseExists(this);
    }

    @Override
    public Multiset<ITermVar> getVars() {
        ImmutableMultiset.Builder vars = ImmutableMultiset.builder();
        vars.addAll(this.vars);
        vars.addAll(this.constraint.getVars());
        return vars.build();
    }

    @Override
    public CExists apply(ISubstitution.Immutable subst) {
        return new CExists(this.vars, this.constraint.apply(subst.removeAll(this.vars)), this.cause);
    }

    @Override
    public CExists apply(IRenaming subst) {
        return new CExists(this.vars, this.constraint.apply(subst), this.cause);
    }

    @Override
    public String toString(TermFormatter termToString) {
        StringBuilder sb = new StringBuilder();
        sb.append("{").append(termToString.format(this.vars)).append("} ");
        sb.append(this.constraint.toString(termToString));
        return sb.toString();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CExists cExists = (CExists)o;
        return Objects.equals(this.vars, cExists.vars) && Objects.equals(this.constraint, cExists.constraint) && Objects.equals(this.cause, cExists.cause);
    }

    public int hashCode() {
        return Objects.hash(this.vars, this.constraint, this.cause);
    }
}

