/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.constraints;

import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.TermFormatter;
import mb.statix.constraints.messages.IMessage;
import mb.statix.solver.IConstraint;

public class CInequal
implements IConstraint,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Set<ITermVar> universals;
    private final ITerm term1;
    private final ITerm term2;
    @Nullable
    private final IConstraint cause;
    @Nullable
    private final IMessage message;

    public CInequal(Iterable<ITermVar> universals, ITerm term1, ITerm term2) {
        this(universals, term1, term2, null, null);
    }

    public CInequal(Iterable<ITermVar> universals, ITerm term1, ITerm term2, @Nullable IMessage message) {
        this(universals, term1, term2, null, message);
    }

    public CInequal(Iterable<ITermVar> universals, ITerm term1, ITerm term2, @Nullable IConstraint cause, @Nullable IMessage message) {
        this.universals = ImmutableSet.copyOf(universals);
        this.term1 = term1;
        this.term2 = term2;
        this.cause = cause;
        this.message = message;
    }

    public Set<ITermVar> universals() {
        return this.universals;
    }

    public ITerm term1() {
        return this.term1;
    }

    public ITerm term2() {
        return this.term2;
    }

    @Override
    public Optional<IConstraint> cause() {
        return Optional.ofNullable(this.cause);
    }

    @Override
    public CInequal withCause(@Nullable IConstraint cause) {
        return new CInequal(this.universals, this.term1, this.term2, cause, this.message);
    }

    @Override
    public Optional<IMessage> message() {
        return Optional.ofNullable(this.message);
    }

    @Override
    public CInequal withMessage(@Nullable IMessage message) {
        return new CInequal(this.universals, this.term1, this.term2, this.cause, message);
    }

    @Override
    public <R> R match(IConstraint.Cases<R> cases) {
        return cases.caseInequal(this);
    }

    @Override
    public <R, E extends Throwable> R matchOrThrow(IConstraint.CheckedCases<R, E> cases) throws E {
        return cases.caseInequal(this);
    }

    @Override
    public Multiset<ITermVar> getVars() {
        ImmutableMultiset.Builder vars = ImmutableMultiset.builder();
        vars.addAll(this.term1.getVars());
        vars.addAll(this.term2.getVars());
        return vars.build();
    }

    @Override
    public CInequal apply(ISubstitution.Immutable subst) {
        Set us = (Set)this.universals.stream().flatMap(v -> subst.apply((ITerm)v).getVars().stream()).collect(ImmutableSet.toImmutableSet());
        return new CInequal(us, subst.apply(this.term1), subst.apply(this.term2), this.cause, this.message == null ? null : this.message.apply(subst));
    }

    @Override
    public CInequal apply(IRenaming subst) {
        Set us = (Set)this.universals.stream().map(v -> subst.rename((ITermVar)v)).collect(ImmutableSet.toImmutableSet());
        return new CInequal(us, subst.apply(this.term1), subst.apply(this.term2), this.cause, this.message == null ? null : this.message.apply(subst));
    }

    @Override
    public String toString(TermFormatter termToString) {
        StringBuilder sb = new StringBuilder();
        if (!this.universals.isEmpty()) {
            sb.append("(forall ");
            sb.append(this.universals.stream().map(termToString::format).collect(Collectors.joining(", ")));
            sb.append(". ");
        }
        sb.append(termToString.format(this.term1));
        sb.append(" != ");
        sb.append(termToString.format(this.term2));
        if (!this.universals.isEmpty()) {
            sb.append(")");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CInequal cInequal = (CInequal)o;
        return Objects.equals(this.universals, cInequal.universals) && Objects.equals(this.term1, cInequal.term1) && Objects.equals(this.term2, cInequal.term2) && Objects.equals(this.cause, cInequal.cause) && Objects.equals(this.message, cInequal.message);
    }

    public int hashCode() {
        return Objects.hash(this.universals, this.term1, this.term2, this.cause, this.message);
    }
}

