/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.constraints;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.TermFormatter;
import mb.statix.solver.IConstraint;

public class CNew
implements IConstraint,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<ITerm> terms;
    @Nullable
    private final IConstraint cause;

    public CNew(Iterable<ITerm> terms) {
        this(terms, null);
    }

    public CNew(Iterable<ITerm> terms, @Nullable IConstraint cause) {
        this.terms = ImmutableList.copyOf(terms);
        this.cause = cause;
    }

    public List<ITerm> terms() {
        return this.terms;
    }

    @Override
    public <R> R match(IConstraint.Cases<R> cases) {
        return cases.caseNew(this);
    }

    @Override
    public <R, E extends Throwable> R matchOrThrow(IConstraint.CheckedCases<R, E> cases) throws E {
        return cases.caseNew(this);
    }

    @Override
    public Optional<IConstraint> cause() {
        return Optional.ofNullable(this.cause);
    }

    @Override
    public CNew withCause(@Nullable IConstraint cause) {
        return new CNew(this.terms, cause);
    }

    @Override
    public Multiset<ITermVar> getVars() {
        ImmutableMultiset.Builder vars = ImmutableMultiset.builder();
        for (ITerm t : this.terms) {
            vars.addAll(t.getVars());
        }
        return vars.build();
    }

    @Override
    public CNew apply(ISubstitution.Immutable subst) {
        return new CNew(subst.apply(this.terms), this.cause);
    }

    @Override
    public CNew apply(IRenaming subst) {
        return new CNew(subst.apply(this.terms), this.cause);
    }

    @Override
    public String toString(TermFormatter termToString) {
        StringBuilder sb = new StringBuilder();
        sb.append("new ");
        sb.append(termToString.format(this.terms, " "));
        return sb.toString();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CNew cNew = (CNew)o;
        return Objects.equals(this.terms, cNew.terms) && Objects.equals(this.cause, cNew.cause);
    }

    public int hashCode() {
        return Objects.hash(this.terms, this.cause);
    }
}

