/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.constraints;

import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.TermFormatter;
import mb.statix.solver.IConstraint;

public class CTellEdge
implements IConstraint,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ITerm sourceTerm;
    private final ITerm label;
    private final ITerm targetTerm;
    @Nullable
    private final IConstraint cause;

    public CTellEdge(ITerm sourceTerm, ITerm label, ITerm targetTerm) {
        this(sourceTerm, label, targetTerm, null);
    }

    public CTellEdge(ITerm sourceTerm, ITerm label, ITerm targetTerm, @Nullable IConstraint cause) {
        this.sourceTerm = sourceTerm;
        this.label = label;
        this.targetTerm = targetTerm;
        this.cause = cause;
    }

    public ITerm sourceTerm() {
        return this.sourceTerm;
    }

    public ITerm label() {
        return this.label;
    }

    public ITerm targetTerm() {
        return this.targetTerm;
    }

    @Override
    public Optional<IConstraint> cause() {
        return Optional.ofNullable(this.cause);
    }

    @Override
    public CTellEdge withCause(@Nullable IConstraint cause) {
        return new CTellEdge(this.sourceTerm, this.label, this.targetTerm, cause);
    }

    @Override
    public <R> R match(IConstraint.Cases<R> cases) {
        return cases.caseTellEdge(this);
    }

    @Override
    public <R, E extends Throwable> R matchOrThrow(IConstraint.CheckedCases<R, E> cases) throws E {
        return cases.caseTellEdge(this);
    }

    @Override
    public Multiset<ITermVar> getVars() {
        ImmutableMultiset.Builder vars = ImmutableMultiset.builder();
        vars.addAll(this.sourceTerm.getVars());
        vars.addAll(this.targetTerm.getVars());
        return vars.build();
    }

    @Override
    public CTellEdge apply(ISubstitution.Immutable subst) {
        return new CTellEdge(subst.apply(this.sourceTerm), this.label, subst.apply(this.targetTerm), this.cause);
    }

    @Override
    public CTellEdge apply(IRenaming subst) {
        return new CTellEdge(subst.apply(this.sourceTerm), this.label, subst.apply(this.targetTerm), this.cause);
    }

    @Override
    public String toString(TermFormatter termToString) {
        StringBuilder sb = new StringBuilder();
        sb.append(termToString.format(this.sourceTerm));
        sb.append(" -");
        sb.append(termToString.format(this.label));
        sb.append("-> ");
        sb.append(termToString.format(this.targetTerm));
        return sb.toString();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CTellEdge cTellEdge = (CTellEdge)o;
        return Objects.equals(this.sourceTerm, cTellEdge.sourceTerm) && Objects.equals(this.label, cTellEdge.label) && Objects.equals(this.targetTerm, cTellEdge.targetTerm) && Objects.equals(this.cause, cTellEdge.cause);
    }

    public int hashCode() {
        return Objects.hash(this.sourceTerm, this.label, this.targetTerm, this.cause);
    }
}

