/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.constraints;

import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.TermFormatter;
import mb.statix.solver.IConstraint;

public class CTellRel
implements IConstraint,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ITerm scopeTerm;
    private final ITerm relation;
    private final ITerm datumTerm;
    @Nullable
    private final IConstraint cause;

    public CTellRel(ITerm scopeTerm, ITerm relation, ITerm datumTerm) {
        this(scopeTerm, relation, datumTerm, null);
    }

    public CTellRel(ITerm scopeTerm, ITerm relation, ITerm datumTerm, @Nullable IConstraint cause) {
        this.scopeTerm = scopeTerm;
        this.relation = relation;
        this.datumTerm = datumTerm;
        this.cause = cause;
    }

    public ITerm scopeTerm() {
        return this.scopeTerm;
    }

    public ITerm relation() {
        return this.relation;
    }

    public ITerm datumTerm() {
        return this.datumTerm;
    }

    @Override
    public Optional<IConstraint> cause() {
        return Optional.ofNullable(this.cause);
    }

    @Override
    public CTellRel withCause(@Nullable IConstraint cause) {
        return new CTellRel(this.scopeTerm, this.relation, this.datumTerm, cause);
    }

    @Override
    public <R> R match(IConstraint.Cases<R> cases) {
        return cases.caseTellRel(this);
    }

    @Override
    public <R, E extends Throwable> R matchOrThrow(IConstraint.CheckedCases<R, E> cases) throws E {
        return cases.caseTellRel(this);
    }

    @Override
    public Multiset<ITermVar> getVars() {
        ImmutableMultiset.Builder vars = ImmutableMultiset.builder();
        vars.addAll(this.scopeTerm.getVars());
        vars.addAll(this.datumTerm.getVars());
        return vars.build();
    }

    @Override
    public CTellRel apply(ISubstitution.Immutable subst) {
        return new CTellRel(subst.apply(this.scopeTerm), this.relation, subst.apply(this.datumTerm));
    }

    @Override
    public CTellRel apply(IRenaming subst) {
        return new CTellRel(subst.apply(this.scopeTerm), this.relation, subst.apply(this.datumTerm));
    }

    @Override
    public String toString(TermFormatter termToString) {
        StringBuilder sb = new StringBuilder();
        sb.append(termToString.format(this.scopeTerm));
        sb.append(" -");
        sb.append(termToString.format(this.relation));
        sb.append("-[] ");
        sb.append(termToString.format(this.datumTerm));
        return sb.toString();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CTellRel cTellRel = (CTellRel)o;
        return Objects.equals(this.scopeTerm, cTellRel.scopeTerm) && Objects.equals(this.relation, cTellRel.relation) && Objects.equals(this.datumTerm, cTellRel.datumTerm) && Objects.equals(this.cause, cTellRel.cause);
    }

    public int hashCode() {
        return Objects.hash(this.scopeTerm, this.relation, this.datumTerm, this.cause);
    }
}

