/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.constraints;

import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.TermFormatter;
import mb.statix.constraints.messages.IMessage;
import mb.statix.solver.IConstraint;

public class CTry
implements IConstraint,
Serializable {
    private static final long serialVersionUID = 1L;
    private final IConstraint constraint;
    @Nullable
    private final IConstraint cause;
    @Nullable
    private final IMessage message;

    public CTry(IConstraint constraint) {
        this(constraint, null, null);
    }

    public CTry(IConstraint constraint, @Nullable IMessage message) {
        this(constraint, null, message);
    }

    public CTry(IConstraint constraint, @Nullable IConstraint cause, @Nullable IMessage message) {
        this.constraint = constraint;
        this.cause = cause;
        this.message = message;
    }

    public IConstraint constraint() {
        return this.constraint;
    }

    @Override
    public Optional<IConstraint> cause() {
        return Optional.ofNullable(this.cause);
    }

    @Override
    public CTry withCause(@Nullable IConstraint cause) {
        return new CTry(this.constraint, cause, this.message);
    }

    @Override
    public Optional<IMessage> message() {
        return Optional.ofNullable(this.message);
    }

    @Override
    public CTry withMessage(@Nullable IMessage message) {
        return new CTry(this.constraint, this.cause, message);
    }

    @Override
    public <R> R match(IConstraint.Cases<R> cases) {
        return cases.caseTry(this);
    }

    @Override
    public <R, E extends Throwable> R matchOrThrow(IConstraint.CheckedCases<R, E> cases) throws E {
        return cases.caseTry(this);
    }

    @Override
    public Multiset<ITermVar> getVars() {
        ImmutableMultiset.Builder vars = ImmutableMultiset.builder();
        vars.addAll(this.constraint.getVars());
        return vars.build();
    }

    @Override
    public CTry apply(ISubstitution.Immutable subst) {
        return new CTry(this.constraint.apply(subst), this.cause, this.message == null ? null : this.message.apply(subst));
    }

    @Override
    public CTry apply(IRenaming subst) {
        return new CTry(this.constraint.apply(subst), this.cause, this.message == null ? null : this.message.apply(subst));
    }

    @Override
    public String toString(TermFormatter termToString) {
        StringBuilder sb = new StringBuilder();
        sb.append("try (");
        sb.append(this.constraint.toString(termToString));
        sb.append(")");
        return sb.toString();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CTry cTry = (CTry)o;
        return Objects.equals(this.constraint, cTry.constraint) && Objects.equals(this.cause, cTry.cause) && Objects.equals(this.message, cTry.message);
    }

    public int hashCode() {
        return Objects.hash(this.constraint, this.cause, this.message);
    }
}

