/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.constraints;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.TermFormatter;
import mb.statix.constraints.messages.IMessage;
import mb.statix.solver.IConstraint;

public class CUser
implements IConstraint,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<ITerm> args;
    @Nullable
    private final IConstraint cause;
    @Nullable
    private final IMessage message;

    public CUser(String name, Iterable<? extends ITerm> args) {
        this(name, args, null, null);
    }

    public CUser(String name, Iterable<? extends ITerm> args, @Nullable IMessage message) {
        this(name, args, null, message);
    }

    public CUser(String name, Iterable<? extends ITerm> args, @Nullable IConstraint cause, @Nullable IMessage message) {
        this.name = name;
        this.args = ImmutableList.copyOf(args);
        this.cause = cause;
        this.message = message;
    }

    public String name() {
        return this.name;
    }

    public List<ITerm> args() {
        return this.args;
    }

    @Override
    public Optional<IConstraint> cause() {
        return Optional.ofNullable(this.cause);
    }

    @Override
    public CUser withCause(@Nullable IConstraint cause) {
        return new CUser(this.name, this.args, cause, this.message);
    }

    @Override
    public Optional<IMessage> message() {
        return Optional.ofNullable(this.message);
    }

    @Override
    public CUser withMessage(@Nullable IMessage message) {
        return new CUser(this.name, this.args, this.cause, message);
    }

    @Override
    public <R> R match(IConstraint.Cases<R> cases) {
        return cases.caseUser(this);
    }

    @Override
    public <R, E extends Throwable> R matchOrThrow(IConstraint.CheckedCases<R, E> cases) throws E {
        return cases.caseUser(this);
    }

    @Override
    public Multiset<ITermVar> getVars() {
        ImmutableMultiset.Builder vars = ImmutableMultiset.builder();
        for (ITerm a : this.args) {
            vars.addAll(a.getVars());
        }
        return vars.build();
    }

    @Override
    public CUser apply(ISubstitution.Immutable subst) {
        return new CUser(this.name, subst.apply(this.args), this.cause, this.message == null ? null : this.message.apply(subst));
    }

    @Override
    public CUser apply(IRenaming subst) {
        return new CUser(this.name, subst.apply(this.args), this.cause, this.message == null ? null : this.message.apply(subst));
    }

    @Override
    public String toString(TermFormatter termToString) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append("(");
        sb.append(termToString.format(this.args));
        sb.append(")");
        return sb.toString();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CUser cUser = (CUser)o;
        return Objects.equals(this.name, cUser.name) && Objects.equals(this.args, cUser.args) && Objects.equals(this.cause, cUser.cause) && Objects.equals(this.message, cUser.message);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.args, this.cause, this.message);
    }
}

