/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.constraints;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import io.usethesource.capsule.Set;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.CapsuleUtil;
import mb.nabl2.util.TermFormatter;
import mb.statix.constraints.CArith;
import mb.statix.constraints.CAstId;
import mb.statix.constraints.CAstProperty;
import mb.statix.constraints.CConj;
import mb.statix.constraints.CEqual;
import mb.statix.constraints.CExists;
import mb.statix.constraints.CFalse;
import mb.statix.constraints.CInequal;
import mb.statix.constraints.CNew;
import mb.statix.constraints.CResolveQuery;
import mb.statix.constraints.CTellEdge;
import mb.statix.constraints.CTellRel;
import mb.statix.constraints.CTrue;
import mb.statix.constraints.CTry;
import mb.statix.constraints.CUser;
import mb.statix.solver.IConstraint;
import mb.statix.spec.RuleUtil;
import org.metaborg.util.functions.Action1;
import org.metaborg.util.functions.CheckedFunction1;
import org.metaborg.util.functions.Function1;
import org.metaborg.util.functions.PartialFunction1;
import org.metaborg.util.optionals.Optionals;

public final class Constraints {
    private Constraints() {
    }

    public static <R> IConstraint.Cases<R> cases(final Function1<CArith, R> onArith, final Function1<CConj, R> onConj, final Function1<CEqual, R> onEqual, final Function1<CExists, R> onExists, final Function1<CFalse, R> onFalse, final Function1<CInequal, R> onInequal, final Function1<CNew, R> onNew, final Function1<CResolveQuery, R> onResolveQuery, final Function1<CTellEdge, R> onTellEdge, final Function1<CTellRel, R> onTellRel, final Function1<CAstId, R> onTermId, final Function1<CAstProperty, R> onTermProperty, final Function1<CTrue, R> onTrue, final Function1<CTry, R> onTry, final Function1<CUser, R> onUser) {
        return new IConstraint.Cases<R>(){

            @Override
            public R caseArith(CArith c) {
                return onArith.apply(c);
            }

            @Override
            public R caseConj(CConj c) {
                return onConj.apply(c);
            }

            @Override
            public R caseEqual(CEqual c) {
                return onEqual.apply(c);
            }

            @Override
            public R caseExists(CExists c) {
                return onExists.apply(c);
            }

            @Override
            public R caseFalse(CFalse c) {
                return onFalse.apply(c);
            }

            @Override
            public R caseInequal(CInequal c) {
                return onInequal.apply(c);
            }

            @Override
            public R caseNew(CNew c) {
                return onNew.apply(c);
            }

            @Override
            public R caseResolveQuery(CResolveQuery c) {
                return onResolveQuery.apply(c);
            }

            @Override
            public R caseTellEdge(CTellEdge c) {
                return onTellEdge.apply(c);
            }

            @Override
            public R caseTellRel(CTellRel c) {
                return onTellRel.apply(c);
            }

            @Override
            public R caseTermId(CAstId c) {
                return onTermId.apply(c);
            }

            @Override
            public R caseTermProperty(CAstProperty c) {
                return onTermProperty.apply(c);
            }

            @Override
            public R caseTrue(CTrue c) {
                return onTrue.apply(c);
            }

            @Override
            public R caseTry(CTry c) {
                return onTry.apply(c);
            }

            @Override
            public R caseUser(CUser c) {
                return onUser.apply(c);
            }
        };
    }

    public static <R> CaseBuilder<R> cases() {
        return new CaseBuilder();
    }

    public static <R, E extends Throwable> IConstraint.CheckedCases<R, E> checkedCases(final CheckedFunction1<CArith, R, E> onArith, final CheckedFunction1<CConj, R, E> onConj, final CheckedFunction1<CEqual, R, E> onEqual, final CheckedFunction1<CExists, R, E> onExists, final CheckedFunction1<CFalse, R, E> onFalse, final CheckedFunction1<CInequal, R, E> onInequal, final CheckedFunction1<CNew, R, E> onNew, final CheckedFunction1<CResolveQuery, R, E> onResolveQuery, final CheckedFunction1<CTellEdge, R, E> onTellEdge, final CheckedFunction1<CTellRel, R, E> onTellRel, final CheckedFunction1<CAstId, R, E> onTermId, final CheckedFunction1<CAstProperty, R, E> onTermProperty, final CheckedFunction1<CTrue, R, E> onTrue, final CheckedFunction1<CTry, R, E> onTry, final CheckedFunction1<CUser, R, E> onUser) {
        return new IConstraint.CheckedCases<R, E>(){

            @Override
            public R caseArith(CArith c) throws Throwable {
                return onArith.apply(c);
            }

            @Override
            public R caseConj(CConj c) throws Throwable {
                return onConj.apply(c);
            }

            @Override
            public R caseEqual(CEqual c) throws Throwable {
                return onEqual.apply(c);
            }

            @Override
            public R caseExists(CExists c) throws Throwable {
                return onExists.apply(c);
            }

            @Override
            public R caseFalse(CFalse c) throws Throwable {
                return onFalse.apply(c);
            }

            @Override
            public R caseInequal(CInequal c) throws Throwable {
                return onInequal.apply(c);
            }

            @Override
            public R caseNew(CNew c) throws Throwable {
                return onNew.apply(c);
            }

            @Override
            public R caseResolveQuery(CResolveQuery c) throws Throwable {
                return onResolveQuery.apply(c);
            }

            @Override
            public R caseTellEdge(CTellEdge c) throws Throwable {
                return onTellEdge.apply(c);
            }

            @Override
            public R caseTellRel(CTellRel c) throws Throwable {
                return onTellRel.apply(c);
            }

            @Override
            public R caseTermId(CAstId c) throws Throwable {
                return onTermId.apply(c);
            }

            @Override
            public R caseTermProperty(CAstProperty c) throws Throwable {
                return onTermProperty.apply(c);
            }

            @Override
            public R caseTrue(CTrue c) throws Throwable {
                return onTrue.apply(c);
            }

            @Override
            public R caseTry(CTry c) throws Throwable {
                return onTry.apply(c);
            }

            @Override
            public R caseUser(CUser c) throws Throwable {
                return onUser.apply(c);
            }
        };
    }

    public static Function1<IConstraint, IConstraint> bottomup(Function1<IConstraint, IConstraint> f, boolean recurseInLogicalScopes) {
        return Constraints.cases(c -> (IConstraint)f.apply((IConstraint)c), c -> (IConstraint)f.apply(new CConj(Constraints.bottomup(f, recurseInLogicalScopes).apply(c.left()), Constraints.bottomup(f, recurseInLogicalScopes).apply(c.right()), c.cause().orElse(null))), c -> (IConstraint)f.apply((IConstraint)c), c -> (IConstraint)f.apply(new CExists(c.vars(), Constraints.bottomup(f, recurseInLogicalScopes).apply(c.constraint()), c.cause().orElse(null))), c -> (IConstraint)f.apply((IConstraint)c), c -> (IConstraint)f.apply((IConstraint)c), c -> (IConstraint)f.apply((IConstraint)c), c -> (IConstraint)f.apply((IConstraint)c), c -> (IConstraint)f.apply((IConstraint)c), c -> (IConstraint)f.apply((IConstraint)c), c -> (IConstraint)f.apply((IConstraint)c), c -> (IConstraint)f.apply((IConstraint)c), c -> (IConstraint)f.apply((IConstraint)c), c -> (IConstraint)f.apply(recurseInLogicalScopes ? new CTry(Constraints.bottomup(f, recurseInLogicalScopes).apply(c.constraint()), c.cause().orElse(null), c.message().orElse(null)) : c), c -> (IConstraint)f.apply((IConstraint)c));
    }

    public static Function1<IConstraint, IConstraint> map(Function1<IConstraint, IConstraint> f, boolean recurseInLogicalScopes) {
        return Constraints.cases(c -> (IConstraint)f.apply((IConstraint)c), c -> {
            IConstraint left = Constraints.map(f, recurseInLogicalScopes).apply(c.left());
            IConstraint right = Constraints.map(f, recurseInLogicalScopes).apply(c.right());
            return new CConj(left, right, c.cause().orElse(null));
        }, c -> (IConstraint)f.apply((IConstraint)c), c -> {
            IConstraint body = Constraints.map(f, recurseInLogicalScopes).apply(c.constraint());
            return new CExists(c.vars(), body, c.cause().orElse(null));
        }, c -> (IConstraint)f.apply((IConstraint)c), c -> (IConstraint)f.apply((IConstraint)c), c -> (IConstraint)f.apply((IConstraint)c), c -> (IConstraint)f.apply((IConstraint)c), c -> (IConstraint)f.apply((IConstraint)c), c -> (IConstraint)f.apply((IConstraint)c), c -> (IConstraint)f.apply((IConstraint)c), c -> (IConstraint)f.apply((IConstraint)c), c -> (IConstraint)f.apply((IConstraint)c), c -> {
            if (recurseInLogicalScopes) {
                IConstraint body = Constraints.map(f, recurseInLogicalScopes).apply(c.constraint());
                return new CTry(body, c.cause().orElse(null), c.message().orElse(null));
            }
            return c;
        }, c -> (IConstraint)f.apply((IConstraint)c));
    }

    public static Function1<IConstraint, Optional<IConstraint>> filter(Function1<IConstraint, Optional<IConstraint>> f, boolean recurseInLogicalScopes) {
        return Constraints.cases(c -> (Optional)f.apply((IConstraint)c), c -> {
            Optional<IConstraint> left = Constraints.filter(f, recurseInLogicalScopes).apply(c.left());
            Optional<IConstraint> right = Constraints.filter(f, recurseInLogicalScopes).apply(c.right());
            return Optionals.lift(left, right, (l, r) -> new CConj((IConstraint)l, (IConstraint)r, c.cause().orElse(null)));
        }, c -> (Optional)f.apply((IConstraint)c), c -> {
            Optional<IConstraint> body = Constraints.filter(f, recurseInLogicalScopes).apply(c.constraint());
            return body.map(b -> new CExists((Iterable<ITermVar>)c.vars(), (IConstraint)b, c.cause().orElse(null)));
        }, c -> (Optional)f.apply((IConstraint)c), c -> (Optional)f.apply((IConstraint)c), c -> (Optional)f.apply((IConstraint)c), c -> (Optional)f.apply((IConstraint)c), c -> (Optional)f.apply((IConstraint)c), c -> (Optional)f.apply((IConstraint)c), c -> (Optional)f.apply((IConstraint)c), c -> (Optional)f.apply((IConstraint)c), c -> (Optional)f.apply((IConstraint)c), c -> {
            if (recurseInLogicalScopes) {
                Optional<IConstraint> body = Constraints.filter(f, recurseInLogicalScopes).apply(c.constraint());
                return body.map(b -> new CTry((IConstraint)b, c.cause().orElse(null), c.message().orElse(null)));
            }
            return Optional.of(c);
        }, c -> (Optional)f.apply((IConstraint)c));
    }

    public static Function1<IConstraint, Stream<IConstraint>> flatMap(Function1<IConstraint, Stream<IConstraint>> f, boolean recurseInLogicalScopes) {
        return Constraints.cases(c -> (Stream)f.apply((IConstraint)c), c -> Constraints.flatMap(f, recurseInLogicalScopes).apply(c.left()).flatMap(l -> Constraints.flatMap(f, recurseInLogicalScopes).apply(c.right()).map(r -> new CConj((IConstraint)l, (IConstraint)r, c.cause().orElse(null)))), c -> (Stream)f.apply((IConstraint)c), c -> Constraints.flatMap(f, recurseInLogicalScopes).apply(c.constraint()).map(b -> new CExists((Iterable<ITermVar>)c.vars(), (IConstraint)b, c.cause().orElse(null))), c -> (Stream)f.apply((IConstraint)c), c -> (Stream)f.apply((IConstraint)c), c -> (Stream)f.apply((IConstraint)c), c -> (Stream)f.apply((IConstraint)c), c -> (Stream)f.apply((IConstraint)c), c -> (Stream)f.apply((IConstraint)c), c -> (Stream)f.apply((IConstraint)c), c -> (Stream)f.apply((IConstraint)c), c -> (Stream)f.apply((IConstraint)c), c -> {
            if (recurseInLogicalScopes) {
                return Constraints.flatMap(f, recurseInLogicalScopes).apply(c.constraint()).map(b -> new CTry((IConstraint)b, c.cause().orElse(null), c.message().orElse(null)));
            }
            return Stream.of(c);
        }, c -> (Stream)f.apply((IConstraint)c));
    }

    public static <T> Function1<IConstraint, List<T>> collectBase(PartialFunction1<IConstraint, T> f, boolean recurseInLogicalScopes) {
        return c -> {
            ImmutableList.Builder ts = ImmutableList.builder();
            Constraints.collectBase(c, f, ts, recurseInLogicalScopes);
            return ts.build();
        };
    }

    private static <T> List<T> collectBase(IConstraint constraint, PartialFunction1<IConstraint, T> f, ImmutableList.Builder<T> ts, boolean recurseInLogicalScopes) {
        return constraint.match(Constraints.cases(c -> {
            ((Optional)f.apply((IConstraint)c)).ifPresent(arg_0 -> ((ImmutableList.Builder)ts).add(arg_0));
            return null;
        }, c -> {
            Constraints.disjoin(c).forEach(cc -> {
                List list = Constraints.collectBase(cc, f, ts, recurseInLogicalScopes);
            });
            return null;
        }, c -> {
            ((Optional)f.apply((IConstraint)c)).ifPresent(arg_0 -> ((ImmutableList.Builder)ts).add(arg_0));
            return null;
        }, c -> {
            Constraints.disjoin(c.constraint()).forEach(cc -> {
                List list = Constraints.collectBase(cc, f, ts, recurseInLogicalScopes);
            });
            return null;
        }, c -> {
            ((Optional)f.apply((IConstraint)c)).ifPresent(arg_0 -> ((ImmutableList.Builder)ts).add(arg_0));
            return null;
        }, c -> {
            ((Optional)f.apply((IConstraint)c)).ifPresent(arg_0 -> ((ImmutableList.Builder)ts).add(arg_0));
            return null;
        }, c -> {
            ((Optional)f.apply((IConstraint)c)).ifPresent(arg_0 -> ((ImmutableList.Builder)ts).add(arg_0));
            return null;
        }, c -> {
            ((Optional)f.apply((IConstraint)c)).ifPresent(arg_0 -> ((ImmutableList.Builder)ts).add(arg_0));
            return null;
        }, c -> {
            ((Optional)f.apply((IConstraint)c)).ifPresent(arg_0 -> ((ImmutableList.Builder)ts).add(arg_0));
            return null;
        }, c -> {
            ((Optional)f.apply((IConstraint)c)).ifPresent(arg_0 -> ((ImmutableList.Builder)ts).add(arg_0));
            return null;
        }, c -> {
            ((Optional)f.apply((IConstraint)c)).ifPresent(arg_0 -> ((ImmutableList.Builder)ts).add(arg_0));
            return null;
        }, c -> {
            ((Optional)f.apply((IConstraint)c)).ifPresent(arg_0 -> ((ImmutableList.Builder)ts).add(arg_0));
            return null;
        }, c -> {
            ((Optional)f.apply((IConstraint)c)).ifPresent(arg_0 -> ((ImmutableList.Builder)ts).add(arg_0));
            return null;
        }, c -> {
            if (recurseInLogicalScopes) {
                Constraints.disjoin(c.constraint()).forEach(cc -> {
                    List list = Constraints.collectBase(cc, f, ts, recurseInLogicalScopes);
                });
            }
            return null;
        }, c -> {
            ((Optional)f.apply((IConstraint)c)).ifPresent(arg_0 -> ((ImmutableList.Builder)ts).add(arg_0));
            return null;
        }));
    }

    public static List<IConstraint> apply(List<IConstraint> constraints, ISubstitution.Immutable subst) {
        return Constraints.apply(constraints, subst, null);
    }

    public static List<IConstraint> apply(List<IConstraint> constraints, ISubstitution.Immutable subst, @Nullable IConstraint cause) {
        return (List)constraints.stream().map(c -> c.apply(subst).withCause(cause)).collect(ImmutableList.toImmutableList());
    }

    public static String toString(Iterable<? extends IConstraint> constraints, TermFormatter termToString) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (IConstraint iConstraint : constraints) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(iConstraint.toString(termToString));
        }
        return sb.toString();
    }

    public static IConstraint conjoin(Iterable<? extends IConstraint> constraints) {
        IConstraint conj = null;
        for (IConstraint iConstraint : constraints) {
            IConstraint iConstraint2 = conj = conj != null ? new CConj(iConstraint, conj) : iConstraint;
        }
        return conj != null ? conj : new CTrue();
    }

    public static IConstraint conjoin(Iterable<? extends IConstraint> constraints, IConstraint tail) {
        IConstraint conj = tail;
        for (IConstraint iConstraint : constraints) {
            IConstraint iConstraint2 = conj = conj != null ? new CConj(iConstraint, conj) : iConstraint;
        }
        return conj;
    }

    public static List<IConstraint> disjoin(IConstraint constraint) {
        ImmutableList.Builder constraints = ImmutableList.builder();
        Constraints.disjoin(constraint, arg_0 -> ((ImmutableList.Builder)constraints).add(arg_0));
        return constraints.build();
    }

    public static void disjoin(IConstraint constraint, Action1<IConstraint> action) {
        LinkedList worklist = Lists.newLinkedList();
        worklist.push(constraint);
        while (!worklist.isEmpty()) {
            ((IConstraint)worklist.pop()).match(Constraints.cases().conj(conj -> {
                worklist.push(conj.left().withCause(conj.cause().orElse(conj.left().cause().orElse(null))));
                worklist.push(conj.right().withCause(conj.cause().orElse(conj.right().cause().orElse(null))));
                return null;
            }).otherwise(c -> {
                action.apply((IConstraint)c);
                return null;
            }));
        }
    }

    public static Set<ITermVar> freeVars(IConstraint constraint) {
        ImmutableSet.Builder freeVars = ImmutableSet.builder();
        Constraints.freeVars(constraint, arg_0 -> ((ImmutableSet.Builder)freeVars).add(arg_0));
        return freeVars.build();
    }

    public static void freeVars(IConstraint constraint, Action1<ITermVar> onVar) {
        constraint.match(Constraints.cases(onArith -> {
            onArith.expr1().isTerm().ifPresent(t -> t.getVars().forEach(onVar::apply));
            onArith.expr2().isTerm().ifPresent(t -> t.getVars().forEach(onVar::apply));
            return null;
        }, onConj -> {
            Constraints.disjoin(onConj).forEach(c -> Constraints.freeVars(c, onVar));
            return null;
        }, onEqual -> {
            onEqual.term1().getVars().forEach(onVar::apply);
            onEqual.term2().getVars().forEach(onVar::apply);
            return null;
        }, onExists -> {
            Constraints.freeVars(onExists.constraint(), v -> {
                if (!onExists.vars().contains(v)) {
                    onVar.apply((ITermVar)v);
                }
            });
            return null;
        }, onFalse -> null, onInequal -> {
            onInequal.term1().getVars().stream().filter(v -> !onInequal.universals().contains(v)).forEach(onVar::apply);
            onInequal.term2().getVars().stream().filter(v -> !onInequal.universals().contains(v)).forEach(onVar::apply);
            return null;
        }, onNew -> {
            onNew.terms().forEach(t -> t.getVars().forEach(onVar::apply));
            return null;
        }, onResolveQuery -> {
            onResolveQuery.scopeTerm().getVars().forEach(onVar::apply);
            RuleUtil.freeVars(onResolveQuery.filter().getDataWF(), onVar);
            RuleUtil.freeVars(onResolveQuery.min().getDataEquiv(), onVar);
            onResolveQuery.resultTerm().getVars().forEach(onVar::apply);
            return null;
        }, onTellEdge -> {
            onTellEdge.sourceTerm().getVars().forEach(onVar::apply);
            onTellEdge.targetTerm().getVars().forEach(onVar::apply);
            return null;
        }, onTellRel -> {
            onTellRel.scopeTerm().getVars().forEach(onVar::apply);
            onTellRel.datumTerm().getVars().forEach(onVar::apply);
            return null;
        }, onTermId -> {
            onTermId.astTerm().getVars().forEach(onVar::apply);
            onTermId.idTerm().getVars().forEach(onVar::apply);
            return null;
        }, onTermProperty -> {
            onTermProperty.idTerm().getVars().forEach(onVar::apply);
            onTermProperty.value().getVars().forEach(onVar::apply);
            return null;
        }, onTrue -> null, onTry -> {
            Constraints.freeVars(onTry.constraint(), onVar);
            return null;
        }, onUser -> {
            onUser.args().forEach(t -> t.getVars().forEach(onVar::apply));
            return null;
        }));
    }

    public static Set<ITermVar> vars(IConstraint constraint) {
        ImmutableSet.Builder vars = ImmutableSet.builder();
        Constraints.vars(constraint, arg_0 -> ((ImmutableSet.Builder)vars).add(arg_0));
        return vars.build();
    }

    public static void vars(IConstraint constraint, Action1<ITermVar> onVar) {
        constraint.match(Constraints.cases(onArith -> {
            onArith.expr1().isTerm().ifPresent(t -> t.getVars().forEach(onVar::apply));
            onArith.expr2().isTerm().ifPresent(t -> t.getVars().forEach(onVar::apply));
            return null;
        }, onConj -> {
            Constraints.disjoin(onConj).forEach(c -> Constraints.vars(c, onVar));
            return null;
        }, onEqual -> {
            onEqual.term1().getVars().forEach(onVar::apply);
            onEqual.term2().getVars().forEach(onVar::apply);
            return null;
        }, onExists -> {
            Constraints.vars(onExists.constraint(), onVar);
            return null;
        }, onFalse -> null, onInequal -> {
            onInequal.term1().getVars().stream().filter(v -> !onInequal.universals().contains(v)).forEach(onVar::apply);
            onInequal.term2().getVars().stream().filter(v -> !onInequal.universals().contains(v)).forEach(onVar::apply);
            return null;
        }, onNew -> {
            onNew.terms().forEach(t -> t.getVars().forEach(onVar::apply));
            return null;
        }, onResolveQuery -> {
            onResolveQuery.scopeTerm().getVars().forEach(onVar::apply);
            RuleUtil.vars(onResolveQuery.filter().getDataWF(), onVar);
            RuleUtil.vars(onResolveQuery.min().getDataEquiv(), onVar);
            onResolveQuery.resultTerm().getVars().forEach(onVar::apply);
            return null;
        }, onTellEdge -> {
            onTellEdge.sourceTerm().getVars().forEach(onVar::apply);
            onTellEdge.targetTerm().getVars().forEach(onVar::apply);
            return null;
        }, onTellRel -> {
            onTellRel.scopeTerm().getVars().forEach(onVar::apply);
            onTellRel.datumTerm().getVars().forEach(onVar::apply);
            return null;
        }, onTermId -> {
            onTermId.astTerm().getVars().forEach(onVar::apply);
            onTermId.idTerm().getVars().forEach(onVar::apply);
            return null;
        }, onTermProperty -> {
            onTermProperty.idTerm().getVars().forEach(onVar::apply);
            onTermProperty.value().getVars().forEach(onVar::apply);
            return null;
        }, onTrue -> null, onTry -> {
            Constraints.vars(onTry.constraint(), onVar);
            return null;
        }, onUser -> {
            onUser.args().forEach(t -> t.getVars().forEach(onVar::apply));
            return null;
        }));
    }

    public static IConstraint exists(Iterable<ITermVar> vars, IConstraint body) {
        Set.Immutable<ITermVar> varSet = CapsuleUtil.toSet(vars);
        return varSet.isEmpty() ? body : new CExists((Iterable<ITermVar>)varSet, body);
    }

    public static class CaseBuilder<R> {
        private Function1<CArith, R> onArith;
        private Function1<CConj, R> onConj;
        private Function1<CEqual, R> onEqual;
        private Function1<CExists, R> onExists;
        private Function1<CFalse, R> onFalse;
        private Function1<CInequal, R> onInequal;
        private Function1<CNew, R> onNew;
        private Function1<CResolveQuery, R> onResolveQuery;
        private Function1<CTellEdge, R> onTellEdge;
        private Function1<CTellRel, R> onTellRel;
        private Function1<CAstId, R> onTermId;
        private Function1<CAstProperty, R> onTermProperty;
        private Function1<CTrue, R> onTrue;
        private Function1<CTry, R> onTry;
        private Function1<CUser, R> onUser;

        public CaseBuilder<R> arith(Function1<CArith, R> onArith) {
            this.onArith = onArith;
            return this;
        }

        public CaseBuilder<R> conj(Function1<CConj, R> onConj) {
            this.onConj = onConj;
            return this;
        }

        public CaseBuilder<R> equal(Function1<CEqual, R> onEqual) {
            this.onEqual = onEqual;
            return this;
        }

        public CaseBuilder<R> exists(Function1<CExists, R> onExists) {
            this.onExists = onExists;
            return this;
        }

        public CaseBuilder<R> _false(Function1<CFalse, R> onFalse) {
            this.onFalse = onFalse;
            return this;
        }

        public CaseBuilder<R> inequal(Function1<CInequal, R> onInequal) {
            this.onInequal = onInequal;
            return this;
        }

        public CaseBuilder<R> _new(Function1<CNew, R> onNew) {
            this.onNew = onNew;
            return this;
        }

        public CaseBuilder<R> resolveQuery(Function1<CResolveQuery, R> onResolveQuery) {
            this.onResolveQuery = onResolveQuery;
            return this;
        }

        public CaseBuilder<R> tellEdge(Function1<CTellEdge, R> onTellEdge) {
            this.onTellEdge = onTellEdge;
            return this;
        }

        public CaseBuilder<R> tellRel(Function1<CTellRel, R> onTellRel) {
            this.onTellRel = onTellRel;
            return this;
        }

        public CaseBuilder<R> termId(Function1<CAstId, R> onTermId) {
            this.onTermId = onTermId;
            return this;
        }

        public CaseBuilder<R> termProperty(Function1<CAstProperty, R> onTermProperty) {
            this.onTermProperty = onTermProperty;
            return this;
        }

        public CaseBuilder<R> _true(Function1<CTrue, R> onTrue) {
            this.onTrue = onTrue;
            return this;
        }

        public CaseBuilder<R> _try(Function1<CTry, R> onTry) {
            this.onTry = onTry;
            return this;
        }

        public CaseBuilder<R> user(Function1<CUser, R> onUser) {
            this.onUser = onUser;
            return this;
        }

        public IConstraint.Cases<R> otherwise(final Function1<IConstraint, R> otherwise) {
            return new IConstraint.Cases<R>(){

                @Override
                public R caseArith(CArith c) {
                    return onArith != null ? onArith.apply(c) : otherwise.apply(c);
                }

                @Override
                public R caseConj(CConj c) {
                    return onConj != null ? onConj.apply(c) : otherwise.apply(c);
                }

                @Override
                public R caseEqual(CEqual c) {
                    return onEqual != null ? onEqual.apply(c) : otherwise.apply(c);
                }

                @Override
                public R caseExists(CExists c) {
                    return onExists != null ? onExists.apply(c) : otherwise.apply(c);
                }

                @Override
                public R caseFalse(CFalse c) {
                    return onFalse != null ? onFalse.apply(c) : otherwise.apply(c);
                }

                @Override
                public R caseInequal(CInequal c) {
                    return onInequal != null ? onInequal.apply(c) : otherwise.apply(c);
                }

                @Override
                public R caseNew(CNew c) {
                    return onNew != null ? onNew.apply(c) : otherwise.apply(c);
                }

                @Override
                public R caseResolveQuery(CResolveQuery c) {
                    return onResolveQuery != null ? onResolveQuery.apply(c) : otherwise.apply(c);
                }

                @Override
                public R caseTellEdge(CTellEdge c) {
                    return onTellEdge != null ? onTellEdge.apply(c) : otherwise.apply(c);
                }

                @Override
                public R caseTellRel(CTellRel c) {
                    return onTellRel != null ? onTellRel.apply(c) : otherwise.apply(c);
                }

                @Override
                public R caseTermId(CAstId c) {
                    return onTermId != null ? onTermId.apply(c) : otherwise.apply(c);
                }

                @Override
                public R caseTermProperty(CAstProperty c) {
                    return onTermProperty != null ? onTermProperty.apply(c) : otherwise.apply(c);
                }

                @Override
                public R caseTrue(CTrue c) {
                    return onTrue != null ? onTrue.apply(c) : otherwise.apply(c);
                }

                @Override
                public R caseTry(CTry c) {
                    return onTry != null ? onTry.apply(c) : otherwise.apply(c);
                }

                @Override
                public R caseUser(CUser c) {
                    return onUser != null ? onUser.apply(c) : otherwise.apply(c);
                }
            };
        }
    }
}

