/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.constraints.messages;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.TermFormatter;
import mb.statix.constraints.messages.IMessage;
import mb.statix.constraints.messages.IMessagePart;
import mb.statix.constraints.messages.MessageKind;

public class Message
implements IMessage,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MessageKind kind;
    private final List<IMessagePart> content;
    @Nullable
    private final ITerm origin;

    public Message(MessageKind kind) {
        this(kind, (Iterable<IMessagePart>)ImmutableList.of(), null);
    }

    public Message(MessageKind kind, Iterable<IMessagePart> content, @Nullable ITerm origin) {
        this.kind = kind;
        this.content = ImmutableList.copyOf(content);
        this.origin = origin;
    }

    @Override
    public MessageKind kind() {
        return this.kind;
    }

    @Override
    public String toString(TermFormatter formatter) {
        return this.content.stream().map(p -> p.toString(formatter)).collect(Collectors.joining());
    }

    @Override
    public Optional<ITerm> origin() {
        return Optional.ofNullable(this.origin);
    }

    @Override
    public IMessage apply(ISubstitution.Immutable subst) {
        List newContent = (List)this.content.stream().map(p -> p.apply(subst)).collect(ImmutableList.toImmutableList());
        ITerm newOrigin = this.origin != null ? subst.apply(this.origin) : null;
        return new Message(this.kind, newContent, newOrigin);
    }

    @Override
    public IMessage apply(IRenaming subst) {
        List newContent = (List)this.content.stream().map(p -> p.apply(subst)).collect(ImmutableList.toImmutableList());
        ITerm newOrigin = this.origin != null ? subst.apply(this.origin) : null;
        return new Message(this.kind, newContent, newOrigin);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.kind);
        sb.append(" $[");
        this.content.forEach(sb::append);
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message message = (Message)o;
        return this.kind == message.kind && Objects.equals(this.content, message.content) && Objects.equals(this.origin, message.origin);
    }

    public int hashCode() {
        return Objects.hash(this.kind, this.content, this.origin);
    }
}

