/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.scopegraph.reference;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import mb.nabl2.terms.ITerm;
import mb.statix.scopegraph.reference.ACriticalEdge;

public final class CriticalEdge
extends ACriticalEdge
implements Serializable {
    private final ITerm scope;
    private final ITerm label;
    private static final long serialVersionUID = 42L;

    private CriticalEdge(ITerm scope, ITerm label) {
        this.scope = Objects.requireNonNull(scope, "scope");
        this.label = Objects.requireNonNull(label, "label");
    }

    private CriticalEdge(CriticalEdge original, ITerm scope, ITerm label) {
        this.scope = scope;
        this.label = label;
    }

    @Override
    public ITerm scope() {
        return this.scope;
    }

    @Override
    public ITerm label() {
        return this.label;
    }

    public final CriticalEdge withScope(ITerm value) {
        if (this.scope == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "scope");
        return new CriticalEdge(this, newValue, this.label);
    }

    public final CriticalEdge withLabel(ITerm value) {
        if (this.label == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "label");
        return new CriticalEdge(this, this.scope, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CriticalEdge && this.equalTo((CriticalEdge)another);
    }

    private boolean equalTo(CriticalEdge another) {
        return this.scope.equals(another.scope) && this.label.equals(another.label);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.scope.hashCode();
        h += (h << 5) + this.label.hashCode();
        return h;
    }

    public static CriticalEdge of(ITerm scope, ITerm label) {
        return new CriticalEdge(scope, label);
    }

    public static CriticalEdge copyOf(ACriticalEdge instance) {
        if (instance instanceof CriticalEdge) {
            return (CriticalEdge)instance;
        }
        return CriticalEdge.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ CriticalEdge(CriticalEdge criticalEdge, ITerm iTerm, ITerm iTerm2, CriticalEdge criticalEdge2) {
        this(criticalEdge, iTerm, iTerm2);
    }

    public static final class Builder {
        private static final long INIT_BIT_SCOPE = 1L;
        private static final long INIT_BIT_LABEL = 2L;
        private long initBits = 3L;
        private ITerm scope;
        private ITerm label;

        private Builder() {
        }

        public final Builder from(ACriticalEdge instance) {
            Objects.requireNonNull(instance, "instance");
            this.scope(instance.scope());
            this.label(instance.label());
            return this;
        }

        public final Builder scope(ITerm scope) {
            this.scope = Objects.requireNonNull(scope, "scope");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder label(ITerm label) {
            this.label = Objects.requireNonNull(label, "label");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public CriticalEdge build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CriticalEdge(null, this.scope, this.label, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("scope");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("label");
            }
            return "Cannot build CriticalEdge, some of required attributes are not set " + attributes;
        }
    }
}

