/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.scopegraph.reference;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import io.usethesource.capsule.Set;
import java.util.Map;
import java.util.Optional;
import mb.nabl2.util.Tuple2;
import mb.statix.scopegraph.INameResolution;
import mb.statix.scopegraph.IScopeGraph;
import mb.statix.scopegraph.path.IResolutionPath;
import mb.statix.scopegraph.path.IScopePath;
import mb.statix.scopegraph.reference.DataLeq;
import mb.statix.scopegraph.reference.DataWF;
import mb.statix.scopegraph.reference.Env;
import mb.statix.scopegraph.reference.IncompleteDataException;
import mb.statix.scopegraph.reference.IncompleteEdgeException;
import mb.statix.scopegraph.reference.LabelOrder;
import mb.statix.scopegraph.reference.LabelWF;
import mb.statix.scopegraph.reference.ResolutionException;
import mb.statix.scopegraph.terms.path.Paths;
import org.metaborg.util.functions.Predicate2;
import org.metaborg.util.task.ICancel;

public class FastNameResolution<S extends D, L, D>
implements INameResolution<S, L, D> {
    private final IScopeGraph<S, L, D> scopeGraph;
    private final L relation;
    private final Set.Immutable<L> labels;
    private final LabelWF<L> labelWF;
    private final LabelOrder<L> labelOrder;
    private final Predicate2<S, L> isEdgeComplete;
    private final DataWF<D> dataWF;
    private final DataLeq<D> dataEquiv;
    private final Predicate2<S, L> isDataComplete;
    private final Map<Set.Immutable<L>, Set.Immutable<L>> maxCache = Maps.newHashMap();
    private final Map<Tuple2<Set.Immutable<L>, L>, Set.Immutable<L>> smallerCache = Maps.newHashMap();

    public FastNameResolution(IScopeGraph<S, L, D> scopeGraph, L relation, LabelWF<L> labelWF, LabelOrder<L> labelOrder, Predicate2<S, L> isEdgeComplete, DataWF<D> dataWF, DataLeq<D> dataEquiv, Predicate2<S, L> isDataComplete) {
        this.scopeGraph = scopeGraph;
        this.relation = relation;
        this.labels = Set.Immutable.of().__insertAll(scopeGraph.getEdgeLabels()).__insert(scopeGraph.getNoDataLabel());
        this.labelWF = labelWF;
        this.labelOrder = labelOrder;
        this.isEdgeComplete = isEdgeComplete;
        this.dataWF = dataWF;
        this.dataEquiv = dataEquiv;
        this.isDataComplete = isDataComplete;
    }

    @Override
    public Env<S, L, D> resolve(S scope, ICancel cancel) throws ResolutionException, InterruptedException {
        return this.env(this.labelWF, Paths.empty(scope), Env.of(), cancel);
    }

    private Env<S, L, D> env(LabelWF<L> re, IScopePath<S, L> path, Iterable<IResolutionPath<S, L, D>> specifics, ICancel cancel) throws ResolutionException, InterruptedException {
        return this.env_L(this.labels, re, path, specifics, cancel);
    }

    private Env<S, L, D> env_L(Set.Immutable<L> L2, LabelWF<L> re, IScopePath<S, L> path, Iterable<IResolutionPath<S, L, D>> specifics, ICancel cancel) throws ResolutionException, InterruptedException {
        cancel.throwIfCancelled();
        Env.Builder env = Env.builder();
        Set.Immutable<L> max_L = this.max(L2);
        for (Object l : max_L) {
            Set.Immutable<L> smaller = this.smaller(L2, l);
            Env<S, L, D> env1 = this.env_L(smaller, re, path, specifics, cancel);
            env.addAll(env1);
            if (!env1.isEmpty() && this.dataEquiv.alwaysTrue()) continue;
            Env env2 = this.env_l(l, re, path, Iterables.concat(specifics, env1), cancel);
            env.addAll(env2);
        }
        return env.build();
    }

    private Env<S, L, D> env_l(L l, LabelWF<L> re, IScopePath<S, L> path, Iterable<IResolutionPath<S, L, D>> specifics, ICancel cancel) throws ResolutionException, InterruptedException {
        if (this.scopeGraph.getEdgeLabels().contains(l)) {
            return this.env_nonEOP(l, re, path, specifics, cancel);
        }
        if (this.scopeGraph.getNoDataLabel().equals(l)) {
            return this.env_EOP(re, path, specifics);
        }
        throw new IllegalStateException("Encountered unknown label " + l);
    }

    private Env<S, L, D> env_EOP(LabelWF<L> re, IScopePath<S, L> path, Iterable<IResolutionPath<S, L, D>> specifics) throws ResolutionException, InterruptedException {
        if (!re.accepting()) {
            return Env.of();
        }
        S scope = path.getTarget();
        if (!this.isDataComplete.test(scope, this.relation)) {
            throw new IncompleteDataException(scope, this.relation);
        }
        Env.Builder<S, L, Object> env = Env.builder();
        if (this.relation.equals(this.scopeGraph.getNoDataLabel())) {
            S datum = scope;
            if (this.dataWF.wf(datum) && this.notShadowed(datum, specifics)) {
                env.add(Paths.resolve(path, this.relation, 0, datum));
            }
        } else {
            int index = 0;
            for (D datum : this.getData(re, path, this.relation)) {
                if (!this.dataWF.wf(datum) || !this.notShadowed(datum, specifics)) continue;
                env.add(Paths.resolve(path, this.relation, index++, datum));
            }
        }
        return env.build();
    }

    private boolean notShadowed(D datum, Iterable<IResolutionPath<S, L, D>> specifics) throws ResolutionException, InterruptedException {
        for (IResolutionPath<S, L, D> p : specifics) {
            if (!this.dataEquiv.leq(p.getDatum(), datum)) continue;
            return false;
        }
        return true;
    }

    private Env<S, L, D> env_nonEOP(L l, LabelWF<L> re, IScopePath<S, L> path, Iterable<IResolutionPath<S, L, D>> specifics, ICancel cancel) throws ResolutionException, InterruptedException {
        Optional<LabelWF<L>> newRe = re.step(l);
        if (!newRe.isPresent()) {
            return Env.of();
        }
        re = newRe.get();
        if (!this.isEdgeComplete.test(path.getTarget(), l)) {
            throw new IncompleteEdgeException(path.getTarget(), l);
        }
        Env.Builder env = Env.builder();
        for (S nextScope : this.getEdges(re, path, l)) {
            Optional<IScopePath<S, L>> p = Paths.append(path, Paths.edge(path.getTarget(), l, nextScope));
            if (!p.isPresent()) continue;
            env.addAll(this.env(re, p.get(), specifics, cancel));
        }
        return env.build();
    }

    protected Iterable<D> getData(LabelWF<L> re, IScopePath<S, L> path, L l) {
        return this.scopeGraph.getData(path.getTarget(), l);
    }

    protected Iterable<S> getEdges(LabelWF<L> re, IScopePath<S, L> path, L l) {
        return this.scopeGraph.getEdges(path.getTarget(), l);
    }

    private Set.Immutable<L> max(Set.Immutable<L> L2) throws ResolutionException, InterruptedException {
        Set.Immutable<L> max2 = this.maxCache.get(L2);
        if (max2 == null) {
            max2 = this.computeMax(L2);
            this.maxCache.put(L2, max2);
        }
        return max2;
    }

    private Set.Immutable<L> computeMax(Set.Immutable<L> L2) throws ResolutionException, InterruptedException {
        Set.Transient max2 = Set.Transient.of();
        block0: for (Object l1 : L2) {
            for (Object l2 : L2) {
                if (this.labelOrder.lt(l1, l2)) continue block0;
            }
            max2.__insert(l1);
        }
        return max2.freeze();
    }

    private Set.Immutable<L> smaller(Set.Immutable<L> L2, L l1) throws ResolutionException, InterruptedException {
        Tuple2<Set.Immutable<L>, L> key = Tuple2.of(L2, l1);
        Set.Immutable<L> smaller = this.smallerCache.get(key);
        if (smaller == null) {
            smaller = this.computeSmaller(L2, l1);
            this.smallerCache.put(key, smaller);
        }
        return smaller;
    }

    private Set.Immutable<L> computeSmaller(Set.Immutable<L> L2, L l1) throws ResolutionException, InterruptedException {
        Set.Transient smaller = Set.Transient.of();
        for (Object l2 : L2) {
            if (!this.labelOrder.lt(l2, l1)) continue;
            smaller.__insert(l2);
        }
        return smaller.freeze();
    }

    public static <S extends D, L, D> Builder<S, L, D> builder() {
        return new Builder();
    }

    public static class Builder<S extends D, L, D>
    implements INameResolution.Builder<S, L, D> {
        private LabelWF<L> labelWF = LabelWF.ANY();
        private LabelOrder<L> labelOrder = LabelOrder.NONE();
        private Predicate2<S, L> isEdgeComplete = (s, l) -> true;
        private DataWF<D> dataWF = DataWF.ANY();
        private DataLeq<D> dataEquiv = DataLeq.NONE();
        private Predicate2<S, L> isDataComplete = (s, r) -> true;

        @Override
        public Builder<S, L, D> withLabelWF(LabelWF<L> labelWF) {
            this.labelWF = labelWF;
            return this;
        }

        @Override
        public Builder<S, L, D> withLabelOrder(LabelOrder<L> labelOrder) {
            this.labelOrder = labelOrder;
            return this;
        }

        @Override
        public Builder<S, L, D> withEdgeComplete(Predicate2<S, L> isEdgeComplete) {
            this.isEdgeComplete = isEdgeComplete;
            return this;
        }

        @Override
        public Builder<S, L, D> withDataWF(DataWF<D> dataWF) {
            this.dataWF = dataWF;
            return this;
        }

        @Override
        public Builder<S, L, D> withDataEquiv(DataLeq<D> dataEquiv) {
            this.dataEquiv = dataEquiv;
            return this;
        }

        @Override
        public Builder<S, L, D> withDataComplete(Predicate2<S, L> isDataComplete) {
            this.isDataComplete = isDataComplete;
            return this;
        }

        @Override
        public FastNameResolution<S, L, D> build(IScopeGraph<S, L, D> scopeGraph, L relation) {
            return new FastNameResolution<S, L, D>(scopeGraph, relation, this.labelWF, this.labelOrder, this.isEdgeComplete, this.dataWF, this.dataEquiv, this.isDataComplete);
        }
    }
}

