/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.scopegraph.reference;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import mb.nabl2.util.CapsuleUtil;
import mb.nabl2.util.Tuple2;
import mb.nabl2.util.collections.ConsList;
import mb.statix.scopegraph.IScopeGraph;

public abstract class ScopeGraph<S extends D, L, D>
implements IScopeGraph<S, L, D> {
    protected ScopeGraph() {
    }

    @Override
    public abstract Map<Tuple2<S, L>, ConsList<S>> getEdges();

    @Override
    public Iterable<S> getEdges(S scope, L label) {
        return (Iterable)this.getEdges().getOrDefault(Tuple2.of(scope, label), ConsList.nil());
    }

    @Override
    public abstract Map<Tuple2<S, L>, ConsList<D>> getData();

    @Override
    public Iterable<D> getData(S scope, L relation) {
        return (Iterable)this.getData().getOrDefault(Tuple2.of(scope, relation), ConsList.nil());
    }

    public static class Immutable<S extends D, L, D>
    extends ScopeGraph<S, L, D>
    implements IScopeGraph.Immutable<S, L, D>,
    Serializable {
        private static final long serialVersionUID = 42L;
        private final Set.Immutable<L> edgeLabels;
        private final Set.Immutable<L> dataLabels;
        private final L noDataLabel;
        private final Map.Immutable<Tuple2<S, L>, ConsList<S>> edges;
        private final Map.Immutable<Tuple2<S, L>, ConsList<D>> data;

        Immutable(Set.Immutable<L> edgeLabels, Set.Immutable<L> dataLabels, L noDataLabel, Map.Immutable<Tuple2<S, L>, ConsList<S>> edges, Map.Immutable<Tuple2<S, L>, ConsList<D>> data) {
            this.edgeLabels = edgeLabels;
            this.dataLabels = dataLabels;
            this.noDataLabel = noDataLabel;
            this.edges = edges;
            this.data = data;
        }

        @Override
        public Set.Immutable<L> getEdgeLabels() {
            return this.edgeLabels;
        }

        @Override
        public Set.Immutable<L> getDataLabels() {
            return this.dataLabels;
        }

        @Override
        public L getNoDataLabel() {
            return this.noDataLabel;
        }

        @Override
        public Map<Tuple2<S, L>, ConsList<S>> getEdges() {
            return this.edges;
        }

        @Override
        public Map<Tuple2<S, L>, ConsList<D>> getData() {
            return this.data;
        }

        @Override
        public Immutable<S, L, D> addEdge(S sourceScope, L label, S targetScope) {
            IScopeGraph.Transient scopeGraph = this.melt();
            ((Transient)scopeGraph).addEdge(sourceScope, label, targetScope);
            return ((Transient)scopeGraph).freeze();
        }

        @Override
        public Immutable<S, L, D> addDatum(S sourceScope, L relation, D datum) {
            IScopeGraph.Transient scopeGraph = this.melt();
            ((Transient)scopeGraph).addDatum(sourceScope, relation, datum);
            return ((Transient)scopeGraph).freeze();
        }

        @Override
        public IScopeGraph.Immutable<S, L, D> addAll(IScopeGraph<S, L, D> other) {
            IScopeGraph.Transient scopeGraph = this.melt();
            ((Transient)scopeGraph).addAll(other);
            return ((Transient)scopeGraph).freeze();
        }

        @Override
        public Transient<S, L, D> melt() {
            return new Transient(this.edgeLabels, this.dataLabels, this.noDataLabel, this.edges.asTransient(), this.data.asTransient());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.edges.hashCode();
            result = 31 * result + this.data.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Immutable other = (Immutable)obj;
            if (!this.edges.equals(other.edges)) {
                return false;
            }
            return this.data.equals(other.data);
        }

        public static <S extends D, L, D> Immutable<S, L, D> of(Iterable<L> edgeLabels, Iterable<L> dataLabels, L noDataLabel) {
            return new Immutable<S, L, D>(CapsuleUtil.toSet(edgeLabels), CapsuleUtil.toSet(dataLabels), noDataLabel, Map.Immutable.of(), Map.Immutable.of());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            AtomicBoolean first = new AtomicBoolean(true);
            this.edges.forEach((key, targetScope) -> {
                sb.append(first.getAndSet(false) ? " " : ", ");
                sb.append(key._1());
                sb.append(" -");
                sb.append(key._2());
                sb.append("-> ");
                sb.append(targetScope);
            });
            this.data.forEach((key, datum) -> {
                sb.append(first.getAndSet(false) ? " " : ", ");
                sb.append(key._1());
                sb.append(" -");
                sb.append(key._2());
                sb.append("-[ ");
                sb.append(datum);
                sb.append("] ");
            });
            sb.append(first.get() ? "}" : " }");
            return sb.toString();
        }
    }

    public static class Transient<S extends D, L, D>
    extends ScopeGraph<S, L, D>
    implements IScopeGraph.Transient<S, L, D> {
        private final Set.Immutable<L> edgeLabels;
        private final Set.Immutable<L> dataLabels;
        private final L noDataLabel;
        private final Map.Transient<Tuple2<S, L>, ConsList<S>> edges;
        private final Map.Transient<Tuple2<S, L>, ConsList<D>> data;

        Transient(Set.Immutable<L> edgeLabels, Set.Immutable<L> dataLabels, L noDataLabel, Map.Transient<Tuple2<S, L>, ConsList<S>> edges, Map.Transient<Tuple2<S, L>, ConsList<D>> data) {
            this.edgeLabels = edgeLabels;
            this.dataLabels = dataLabels;
            this.noDataLabel = noDataLabel;
            this.edges = edges;
            this.data = data;
        }

        @Override
        public Set.Immutable<L> getEdgeLabels() {
            return this.edgeLabels;
        }

        @Override
        public Set.Immutable<L> getDataLabels() {
            return this.dataLabels;
        }

        @Override
        public L getNoDataLabel() {
            return this.noDataLabel;
        }

        @Override
        public Map<Tuple2<S, L>, ConsList<S>> getEdges() {
            return this.edges;
        }

        @Override
        public Map<Tuple2<S, L>, ConsList<D>> getData() {
            return this.data;
        }

        @Override
        public boolean addEdge(S sourceScope, L label, S targetScope) {
            Tuple2<S, L> key = Tuple2.of(sourceScope, label);
            ConsList scopes = (ConsList)this.edges.getOrDefault(key, ConsList.nil());
            this.edges.__put(key, scopes.prepend(targetScope));
            return true;
        }

        @Override
        public boolean addDatum(S scope, L relation, D datum) {
            Tuple2<S, L> key = Tuple2.of(scope, relation);
            ConsList datums = (ConsList)this.data.getOrDefault(key, ConsList.nil());
            this.data.__put(key, datums.prepend(datum));
            return true;
        }

        @Override
        public boolean addAll(IScopeGraph<S, L, D> other) {
            Tuple2<S, L> key;
            for (Map.Entry<Map.Entry<S, L>, Iterable<S>> entry : other.getEdges().entrySet()) {
                key = Tuple2.of(entry.getKey());
                Iterable<S> otherScopes = entry.getValue();
                ConsList scopes = (ConsList)this.edges.getOrDefault(key, ConsList.nil());
                ConsList<S> mergedScopes = scopes.prepend(ConsList.of(otherScopes));
                this.edges.__put(Tuple2.of(key), mergedScopes);
            }
            for (Map.Entry<Map.Entry<S, L>, Iterable<Object>> entry : other.getData().entrySet()) {
                key = Tuple2.of(entry.getKey());
                Iterable<Object> otherDatums = entry.getValue();
                ConsList datums = (ConsList)this.data.getOrDefault(key, ConsList.nil());
                ConsList<Object> mergedDatums = datums.prepend(ConsList.of(otherDatums));
                this.data.__put(Tuple2.of(key), mergedDatums);
            }
            return true;
        }

        @Override
        public Immutable<S, L, D> freeze() {
            return new Immutable(this.edgeLabels, this.dataLabels, this.noDataLabel, this.edges.freeze(), this.data.freeze());
        }

        public static <S extends D, L, D> Transient<S, L, D> of(Iterable<L> edgeLabels, Iterable<L> dataLabels, L noDataLabel) {
            return new Transient<S, L, D>(CapsuleUtil.toSet(edgeLabels), CapsuleUtil.toSet(dataLabels), noDataLabel, Map.Transient.of(), Map.Transient.of());
        }
    }
}

