/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.scopegraph.terms;

import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableMultiset;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.AbstractTerm;
import mb.statix.scopegraph.terms.AScope;
import mb.statix.scopegraph.terms.IScope;

public final class Scope
extends AScope
implements Serializable {
    private final ImmutableClassToInstanceMap<Object> attachments;
    private final String resource;
    private final String name;
    private volatile transient long lazyInitBitmap;
    private static final long ARITY_LAZY_INIT_BIT = 1L;
    private transient int arity;
    private static final long GROUND_LAZY_INIT_BIT = 2L;
    private transient boolean ground;
    private static final long VARS_LAZY_INIT_BIT = 4L;
    private transient ImmutableMultiset<ITermVar> vars;
    private static final long ARGS_LAZY_INIT_BIT = 8L;
    private transient List<ITerm> args;
    private static final long serialVersionUID = 42L;

    private Scope(String resource, String name) {
        this.resource = Objects.requireNonNull(resource, "resource");
        this.name = Objects.requireNonNull(name, "name");
        this.attachments = Objects.requireNonNull(super.getAttachments(), "attachments");
    }

    private Scope(Builder builder) {
        this.resource = builder.resource;
        this.name = builder.name;
        this.attachments = builder.attachments != null ? builder.attachments : Objects.requireNonNull(super.getAttachments(), "attachments");
    }

    private Scope(ImmutableClassToInstanceMap<Object> attachments, String resource, String name) {
        this.attachments = attachments;
        this.resource = resource;
        this.name = name;
    }

    @Override
    public ImmutableClassToInstanceMap<Object> getAttachments() {
        return this.attachments;
    }

    @Override
    public String getResource() {
        return this.resource;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public final Scope withAttachments(ImmutableClassToInstanceMap<Object> value) {
        if (this.attachments == value) {
            return this;
        }
        ImmutableClassToInstanceMap<Object> newValue = Objects.requireNonNull(value, "attachments");
        return new Scope(newValue, this.resource, this.name);
    }

    public final Scope withResource(String value) {
        String newValue = Objects.requireNonNull(value, "resource");
        if (this.resource.equals(newValue)) {
            return this;
        }
        return new Scope(this.attachments, newValue, this.name);
    }

    public final Scope withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new Scope(this.attachments, this.resource, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getArity() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            Scope scope = this;
            synchronized (scope) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.arity = super.getArity();
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.arity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isGround() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            Scope scope = this;
            synchronized (scope) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.ground = super.isGround();
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.ground;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableMultiset<ITermVar> getVars() {
        if ((this.lazyInitBitmap & 4L) == 0L) {
            Scope scope = this;
            synchronized (scope) {
                if ((this.lazyInitBitmap & 4L) == 0L) {
                    this.vars = Objects.requireNonNull(super.getVars(), "vars");
                    this.lazyInitBitmap |= 4L;
                }
            }
        }
        return this.vars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ITerm> getArgs() {
        if ((this.lazyInitBitmap & 8L) == 0L) {
            Scope scope = this;
            synchronized (scope) {
                if ((this.lazyInitBitmap & 8L) == 0L) {
                    this.args = Objects.requireNonNull(super.getArgs(), "args");
                    this.lazyInitBitmap |= 8L;
                }
            }
        }
        return this.args;
    }

    public static Scope of(String resource, String name) {
        return new Scope(resource, name);
    }

    public static Scope copyOf(AScope instance) {
        if (instance instanceof Scope) {
            return (Scope)instance;
        }
        return Scope.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ Scope(Builder builder, Scope scope) {
        this(builder);
    }

    public static final class Builder {
        private static final long INIT_BIT_RESOURCE = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private long initBits = 3L;
        private ImmutableClassToInstanceMap<Object> attachments;
        private String resource;
        private String name;

        private Builder() {
        }

        public final Builder from(ITerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractTerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(IScope instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AScope instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof ITerm) {
                instance = (ITerm)object;
                if ((bits & 1L) == 0L) {
                    this.attachments(instance.getAttachments());
                    bits |= 1L;
                }
            }
            if (object instanceof AbstractTerm) {
                instance = (AbstractTerm)object;
                if ((bits & 1L) == 0L) {
                    this.attachments(((AbstractTerm)instance).getAttachments());
                    bits |= 1L;
                }
            }
            if (object instanceof IScope) {
                instance = (IScope)object;
                if ((bits & 4L) == 0L) {
                    this.name(instance.getName());
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    this.resource(instance.getResource());
                    bits |= 2L;
                }
            }
            if (object instanceof AScope) {
                instance = (AScope)object;
                if ((bits & 4L) == 0L) {
                    this.name(((AScope)instance).getName());
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    this.resource(((AScope)instance).getResource());
                    bits |= 2L;
                }
            }
        }

        public final Builder attachments(ImmutableClassToInstanceMap<Object> attachments) {
            this.attachments = Objects.requireNonNull(attachments, "attachments");
            return this;
        }

        public final Builder resource(String resource) {
            this.resource = Objects.requireNonNull(resource, "resource");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Scope build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Scope(this, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("resource");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build Scope, some of required attributes are not set " + attributes;
        }
    }
}

