/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.scopegraph.terms.path;

import io.usethesource.capsule.Set;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import mb.nabl2.util.collections.ConsList;
import mb.statix.scopegraph.path.IScopePath;
import mb.statix.scopegraph.terms.path.AResolutionPath;

final class ResolutionPath<S, L, D>
extends AResolutionPath<S, L, D>
implements Serializable {
    private final IScopePath<S, L> path;
    private final L label;
    private final int index;
    private final D datum;
    private volatile transient long lazyInitBitmap;
    private static final long SCOPES_LAZY_INIT_BIT = 1L;
    private transient ConsList<S> scopes;
    private static final long SCOPE_SET_LAZY_INIT_BIT = 2L;
    private transient Set.Immutable<S> scopeSet;
    private static final long LABELS_LAZY_INIT_BIT = 4L;
    private transient ConsList<L> labels;
    private static final long serialVersionUID = 42L;

    private ResolutionPath(IScopePath<S, L> path, L label, int index, D datum) {
        this.path = Objects.requireNonNull(path, "path");
        this.label = Objects.requireNonNull(label, "label");
        this.index = index;
        this.datum = Objects.requireNonNull(datum, "datum");
    }

    private ResolutionPath(ResolutionPath<S, L, D> original, IScopePath<S, L> path, L label, int index, D datum) {
        this.path = path;
        this.label = label;
        this.index = index;
        this.datum = datum;
    }

    @Override
    public IScopePath<S, L> getPath() {
        return this.path;
    }

    @Override
    public L getLabel() {
        return this.label;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public D getDatum() {
        return this.datum;
    }

    public final ResolutionPath<S, L, D> withPath(IScopePath<S, L> value) {
        if (this.path == value) {
            return this;
        }
        IScopePath<S, L> newValue = Objects.requireNonNull(value, "path");
        return ResolutionPath.validate(new ResolutionPath<S, L, D>(this, newValue, this.label, this.index, this.datum));
    }

    public final ResolutionPath<S, L, D> withLabel(L value) {
        if (this.label == value) {
            return this;
        }
        L newValue = Objects.requireNonNull(value, "label");
        return ResolutionPath.validate(new ResolutionPath<S, L, D>(this, this.path, newValue, this.index, this.datum));
    }

    public final ResolutionPath<S, L, D> withIndex(int value) {
        if (this.index == value) {
            return this;
        }
        return ResolutionPath.validate(new ResolutionPath<S, L, D>(this, this.path, this.label, value, this.datum));
    }

    public final ResolutionPath<S, L, D> withDatum(D value) {
        if (this.datum == value) {
            return this;
        }
        D newValue = Objects.requireNonNull(value, "datum");
        return ResolutionPath.validate(new ResolutionPath<S, L, D>(this, this.path, this.label, this.index, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ResolutionPath && this.equalTo((ResolutionPath)another);
    }

    private boolean equalTo(ResolutionPath<?, ?, ?> another) {
        return this.path.equals(another.path) && this.label.equals(another.label) && this.index == another.index && this.datum.equals(another.datum);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.path.hashCode();
        h += (h << 5) + this.label.hashCode();
        h += (h << 5) + this.index;
        h += (h << 5) + this.datum.hashCode();
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConsList<S> scopes() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ResolutionPath resolutionPath = this;
            synchronized (resolutionPath) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.scopes = Objects.requireNonNull(super.scopes(), "scopes");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.scopes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set.Immutable<S> scopeSet() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ResolutionPath resolutionPath = this;
            synchronized (resolutionPath) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.scopeSet = Objects.requireNonNull(super.scopeSet(), "scopeSet");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.scopeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConsList<L> labels() {
        if ((this.lazyInitBitmap & 4L) == 0L) {
            ResolutionPath resolutionPath = this;
            synchronized (resolutionPath) {
                if ((this.lazyInitBitmap & 4L) == 0L) {
                    this.labels = Objects.requireNonNull(super.labels(), "labels");
                    this.lazyInitBitmap |= 4L;
                }
            }
        }
        return this.labels;
    }

    public static <S, L, D> ResolutionPath<S, L, D> of(IScopePath<S, L> path, L label, int index, D datum) {
        return ResolutionPath.validate(new ResolutionPath<S, L, D>(path, label, index, datum));
    }

    private static <S, L, D> ResolutionPath<S, L, D> validate(ResolutionPath<S, L, D> instance) {
        instance = (ResolutionPath)instance.check();
        return instance;
    }

    public static <S, L, D> ResolutionPath<S, L, D> copyOf(AResolutionPath<S, L, D> instance) {
        if (instance instanceof ResolutionPath) {
            return (ResolutionPath)instance;
        }
        return ResolutionPath.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return ResolutionPath.validate(this);
    }

    public static <S, L, D> Builder<S, L, D> builder() {
        return new Builder();
    }

    /* synthetic */ ResolutionPath(ResolutionPath resolutionPath, IScopePath iScopePath, Object object, int n, Object object2, ResolutionPath resolutionPath2) {
        this(resolutionPath, iScopePath, object, n, object2);
    }

    public static final class Builder<S, L, D> {
        private static final long INIT_BIT_PATH = 1L;
        private static final long INIT_BIT_LABEL = 2L;
        private static final long INIT_BIT_INDEX = 4L;
        private static final long INIT_BIT_DATUM = 8L;
        private long initBits = 15L;
        private IScopePath<S, L> path;
        private L label;
        private int index;
        private D datum;

        private Builder() {
        }

        public final Builder<S, L, D> from(AResolutionPath<S, L, D> instance) {
            Objects.requireNonNull(instance, "instance");
            this.path(instance.getPath());
            this.label(instance.getLabel());
            this.index(instance.getIndex());
            this.datum(instance.getDatum());
            return this;
        }

        public final Builder<S, L, D> path(IScopePath<S, L> path) {
            this.path = Objects.requireNonNull(path, "path");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<S, L, D> label(L label) {
            this.label = Objects.requireNonNull(label, "label");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder<S, L, D> index(int index) {
            this.index = index;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder<S, L, D> datum(D datum) {
            this.datum = Objects.requireNonNull(datum, "datum");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ResolutionPath<S, L, D> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ResolutionPath.validate(new ResolutionPath(null, this.path, this.label, this.index, this.datum, null));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("path");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("label");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("index");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("datum");
            }
            return "Cannot build ResolutionPath, some of required attributes are not set " + attributes;
        }
    }
}

