/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver;

import com.google.common.collect.Multiset;
import java.util.Optional;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.TermFormatter;
import mb.statix.constraints.CArith;
import mb.statix.constraints.CAstId;
import mb.statix.constraints.CAstProperty;
import mb.statix.constraints.CConj;
import mb.statix.constraints.CEqual;
import mb.statix.constraints.CExists;
import mb.statix.constraints.CFalse;
import mb.statix.constraints.CInequal;
import mb.statix.constraints.CNew;
import mb.statix.constraints.CResolveQuery;
import mb.statix.constraints.CTellEdge;
import mb.statix.constraints.CTellRel;
import mb.statix.constraints.CTrue;
import mb.statix.constraints.CTry;
import mb.statix.constraints.CUser;
import mb.statix.constraints.messages.IMessage;
import org.metaborg.util.functions.CheckedFunction1;
import org.metaborg.util.functions.Function1;

public interface IConstraint {
    public Optional<IConstraint> cause();

    public IConstraint withCause(IConstraint var1);

    default public Optional<IMessage> message() {
        return Optional.empty();
    }

    default public IConstraint withMessage(IMessage msg) {
        return this;
    }

    public <R> R match(Cases<R> var1);

    public <R, E extends Throwable> R matchOrThrow(CheckedCases<R, E> var1) throws E;

    public Multiset<ITermVar> getVars();

    public IConstraint apply(ISubstitution.Immutable var1);

    public IConstraint apply(IRenaming var1);

    public String toString(TermFormatter var1);

    public static interface Cases<R>
    extends Function1<IConstraint, R> {
        public R caseArith(CArith var1);

        public R caseConj(CConj var1);

        public R caseEqual(CEqual var1);

        public R caseExists(CExists var1);

        public R caseFalse(CFalse var1);

        public R caseInequal(CInequal var1);

        public R caseNew(CNew var1);

        public R caseResolveQuery(CResolveQuery var1);

        public R caseTellEdge(CTellEdge var1);

        public R caseTellRel(CTellRel var1);

        public R caseTermId(CAstId var1);

        public R caseTermProperty(CAstProperty var1);

        public R caseTrue(CTrue var1);

        public R caseTry(CTry var1);

        public R caseUser(CUser var1);

        @Override
        default public R apply(IConstraint c) {
            return c.match(this);
        }
    }

    public static interface CheckedCases<R, E extends Throwable>
    extends CheckedFunction1<IConstraint, R, E> {
        public R caseArith(CArith var1) throws E;

        public R caseConj(CConj var1) throws E;

        public R caseEqual(CEqual var1) throws E;

        public R caseExists(CExists var1) throws E;

        public R caseFalse(CFalse var1) throws E;

        public R caseInequal(CInequal var1) throws E;

        public R caseNew(CNew var1) throws E;

        public R caseResolveQuery(CResolveQuery var1) throws E;

        public R caseTellEdge(CTellEdge var1) throws E;

        public R caseTellRel(CTellRel var1) throws E;

        public R caseTermId(CAstId var1) throws E;

        public R caseTermProperty(CAstProperty var1) throws E;

        public R caseTrue(CTrue var1) throws E;

        public R caseTry(CTry var1) throws E;

        public R caseUser(CUser var1) throws E;

        @Override
        default public R apply(IConstraint c) throws E {
            return c.matchOrThrow(this);
        }
    }
}

