/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.stratego.TermIndex;
import mb.nabl2.terms.unification.ud.IUniDisunifier;
import mb.nabl2.util.Tuple2;
import mb.statix.scopegraph.IScopeGraph;
import mb.statix.scopegraph.terms.Scope;
import mb.statix.solver.ITermProperty;

public interface IState {
    public String resource();

    public Set<ITermVar> vars();

    public Set<Scope> scopes();

    public IUniDisunifier unifier();

    public IScopeGraph<Scope, ITerm, ITerm> scopeGraph();

    public Map<Tuple2<TermIndex, ITerm>, ITermProperty> termProperties();

    public static interface Immutable
    extends IState {
        public Immutable withResource(String var1);

        public Tuple2<ITermVar, Immutable> freshWld();

        public Tuple2<ITermVar, Immutable> freshVar(ITermVar var1);

        public Tuple2<Scope, Immutable> freshScope(String var1);

        public Immutable add(Immutable var1);

        public Set.Immutable<ITermVar> vars();

        public Set.Immutable<Scope> scopes();

        @Override
        public IUniDisunifier.Immutable unifier();

        public Immutable withUnifier(IUniDisunifier.Immutable var1);

        public IScopeGraph.Immutable<Scope, ITerm, ITerm> scopeGraph();

        public Immutable withScopeGraph(IScopeGraph.Immutable<Scope, ITerm, ITerm> var1);

        public Map.Immutable<Tuple2<TermIndex, ITerm>, ITermProperty> termProperties();

        public Immutable withTermProperties(Map.Immutable<Tuple2<TermIndex, ITerm>, ITermProperty> var1);

        default public Transient melt() {
            return new Transient(this);
        }
    }

    public static class Transient
    implements IState {
        private Immutable state;
        private boolean frozen = false;

        private Transient(Immutable state) {
            this.state = state;
        }

        @Override
        public String resource() {
            this.freezeTwiceShameOnYou();
            return this.state.resource();
        }

        @Override
        public Set<ITermVar> vars() {
            this.freezeTwiceShameOnYou();
            return this.state.vars();
        }

        @Override
        public Set<Scope> scopes() {
            this.freezeTwiceShameOnYou();
            return this.state.scopes();
        }

        @Override
        public IUniDisunifier unifier() {
            this.freezeTwiceShameOnYou();
            return this.state.unifier();
        }

        @Override
        public IScopeGraph<Scope, ITerm, ITerm> scopeGraph() {
            this.freezeTwiceShameOnYou();
            return this.state.scopeGraph();
        }

        @Override
        public Map<Tuple2<TermIndex, ITerm>, ITermProperty> termProperties() {
            this.freezeTwiceShameOnYou();
            return this.state.termProperties();
        }

        public ITermVar freshVar(ITermVar var) {
            this.freezeTwiceShameOnYou();
            Tuple2<ITermVar, Immutable> result = this.state.freshVar(var);
            this.state = result._2();
            return result._1();
        }

        public ITermVar freshWld() {
            this.freezeTwiceShameOnYou();
            Tuple2<ITermVar, Immutable> result = this.state.freshWld();
            this.state = result._2();
            return result._1();
        }

        public Scope freshScope(String base) {
            this.freezeTwiceShameOnYou();
            Tuple2<Scope, Immutable> result = this.state.freshScope(base);
            this.state = result._2();
            return result._1();
        }

        public Immutable freeze() {
            this.freezeTwiceShameOnYou();
            this.frozen = true;
            return this.state;
        }

        void freezeTwiceShameOnYou() {
            if (this.frozen) {
                throw new IllegalStateException("Already frozen, cannot modify further.");
            }
        }
    }
}

