/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver;

import com.google.common.collect.ImmutableList;
import io.usethesource.capsule.Map;
import java.util.List;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.nabl2.terms.unification.ud.Diseq;
import mb.nabl2.terms.unification.ud.IUniDisunifier;
import mb.nabl2.util.Tuple2;
import mb.statix.constraints.CAstProperty;
import mb.statix.constraints.CEqual;
import mb.statix.constraints.CInequal;
import mb.statix.constraints.CTellEdge;
import mb.statix.constraints.CTellRel;
import mb.statix.scopegraph.IScopeGraph;
import mb.statix.solver.IConstraint;
import mb.statix.solver.ITermProperty;
import org.metaborg.util.functions.Action1;

public class StateUtil {
    public static List<IConstraint> asConstraint(IScopeGraph<? extends ITerm, ? extends ITerm, ? extends ITerm> scopeGraph) {
        ImmutableList.Builder constraints = ImmutableList.builder();
        scopeGraph.getData().forEach((scopeLabel, data) -> data.forEach(datum -> constraints.add((Object)new CTellRel((ITerm)scopeLabel.getKey(), (ITerm)scopeLabel.getValue(), (ITerm)datum))));
        scopeGraph.getEdges().forEach((scopeLabel, scopes) -> scopes.forEach(scope -> constraints.add((Object)new CTellEdge((ITerm)scopeLabel.getKey(), (ITerm)scopeLabel.getValue(), (ITerm)scope))));
        return constraints.build();
    }

    public static List<IConstraint> asConstraint(Map.Immutable<Tuple2<? extends ITerm, ? extends ITerm>, ? extends ITermProperty> termProperties) {
        ImmutableList.Builder constraints = ImmutableList.builder();
        termProperties.entrySet().forEach(entry -> {
            Tuple2 idxProp = (Tuple2)entry.getKey();
            ITermProperty property = (ITermProperty)entry.getValue();
            switch (property.multiplicity()) {
                case BAG: {
                    property.values().forEach(value -> constraints.add((Object)new CAstProperty((ITerm)idxProp._1(), (ITerm)idxProp._2(), CAstProperty.Op.ADD, (ITerm)value)));
                    break;
                }
                case SINGLETON: {
                    constraints.add((Object)new CAstProperty((ITerm)idxProp._1(), (ITerm)idxProp._2(), CAstProperty.Op.SET, property.value()));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown multiplicity " + (Object)((Object)property.multiplicity()));
                }
            }
        });
        return constraints.build();
    }

    public static List<IConstraint> asConstraint(IUniDisunifier unifier) {
        ImmutableList.Builder constraints = ImmutableList.builder();
        StateUtil.buildEqualities(unifier, arg_0 -> ((ImmutableList.Builder)constraints).add(arg_0));
        StateUtil.buildInequalities(unifier.disequalities(), arg_0 -> ((ImmutableList.Builder)constraints).add(arg_0));
        return constraints.build();
    }

    public static List<CEqual> asEqualities(IUnifier unifier) {
        ImmutableList.Builder constraints = ImmutableList.builder();
        StateUtil.buildEqualities(unifier, arg_0 -> ((ImmutableList.Builder)constraints).add(arg_0));
        return constraints.build();
    }

    public static List<CInequal> asInequalities(IUniDisunifier unifier) {
        ImmutableList.Builder constraints = ImmutableList.builder();
        StateUtil.buildInequalities(unifier.disequalities(), arg_0 -> ((ImmutableList.Builder)constraints).add(arg_0));
        return constraints.build();
    }

    private static void buildEqualities(IUnifier unifier, Action1<CEqual> add2) {
        unifier.equalityMap().forEach((left, right) -> add2.apply(new CEqual((ITerm)left, (ITerm)right)));
    }

    private static void buildInequalities(Iterable<Diseq> diseqs, Action1<CInequal> add2) {
        diseqs.forEach(diseq -> diseq.toTuple().apply((us, left, right) -> {
            add2.apply(new CInequal((Iterable<ITermVar>)us, (ITerm)left, (ITerm)right));
            return null;
        }));
    }
}

