/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.completeness;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.unification.ud.IUniDisunifier;
import mb.nabl2.util.collections.MultiSet;
import mb.statix.scopegraph.reference.CriticalEdge;
import mb.statix.scopegraph.terms.Scope;
import mb.statix.solver.IConstraint;
import mb.statix.solver.completeness.CompletenessUtil;
import mb.statix.solver.completeness.ICompleteness;
import mb.statix.spec.Spec;

public abstract class Completeness
implements ICompleteness {
    protected abstract Map<ITerm, ? extends MultiSet<ITerm>> incomplete();

    @Override
    public boolean isEmpty() {
        return this.incomplete().isEmpty();
    }

    @Override
    public boolean isComplete(Scope scope, ITerm label, IUniDisunifier unifier) {
        if (!label.isGround()) {
            throw new IllegalArgumentException("Label must be ground");
        }
        return Completeness.getVarOrScope(scope, unifier).map(scopeOrVar -> !this.incomplete().containsKey(scopeOrVar) || ((MultiSet)this.incomplete().get(scopeOrVar)).count(label) <= 0).orElse(true);
    }

    protected static Optional<ITerm> getVarOrScope(ITerm scope, IUniDisunifier unifier) {
        return CompletenessUtil.scopeOrVar().match(scope, unifier);
    }

    public String toString() {
        return this.incomplete().entrySet().stream().map(e -> e.getKey() + ": " + e.getValue()).collect(Collectors.joining(", ", "{", "}"));
    }

    public static class Immutable
    extends Completeness
    implements ICompleteness.Immutable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Spec spec;
        private final Map.Immutable<ITerm, MultiSet.Immutable<ITerm>> incomplete;

        private Immutable(Spec spec, Map.Immutable<ITerm, MultiSet.Immutable<ITerm>> incomplete) {
            this.spec = spec;
            this.incomplete = incomplete;
        }

        @Override
        protected Map<ITerm, ? extends MultiSet<ITerm>> incomplete() {
            return this.incomplete;
        }

        @Override
        public Transient melt() {
            return new Transient(this.spec, this.incomplete.asTransient());
        }

        public static Immutable of(Spec spec) {
            return new Immutable(spec, (Map.Immutable<ITerm, MultiSet.Immutable<ITerm>>)Map.Immutable.of());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Immutable immutable = (Immutable)o;
            return this.spec.equals(immutable.spec) && this.incomplete.equals(immutable.incomplete);
        }

        public int hashCode() {
            return Objects.hash(this.spec, this.incomplete);
        }
    }

    public static class Transient
    extends Completeness
    implements ICompleteness.Transient {
        private final Spec spec;
        private final Map.Transient<ITerm, MultiSet.Immutable<ITerm>> incomplete;

        private Transient(Spec spec, Map.Transient<ITerm, MultiSet.Immutable<ITerm>> incomplete) {
            this.spec = spec;
            this.incomplete = incomplete;
        }

        @Override
        protected Map<ITerm, ? extends MultiSet<ITerm>> incomplete() {
            return this.incomplete;
        }

        @Override
        public void add(IConstraint constraint, IUniDisunifier unifier) {
            CompletenessUtil.criticalEdges(constraint, this.spec, (scopeTerm, label) -> Transient.getVarOrScope(scopeTerm, unifier).ifPresent(scopeOrVar -> {
                MultiSet.Transient<ITerm> labels = ((MultiSet.Immutable)this.incomplete.getOrDefault(scopeOrVar, MultiSet.Immutable.of())).melt();
                labels.add((ITerm)label);
                this.incomplete.__put(scopeOrVar, labels.freeze());
            }));
        }

        public Set<CriticalEdge> remove(IConstraint constraint, IUniDisunifier unifier) {
            Set.Transient removedEdges = Set.Transient.of();
            CompletenessUtil.criticalEdges(constraint, this.spec, (scopeTerm, label) -> Transient.getVarOrScope(scopeTerm, unifier).ifPresent(scopeOrVar -> {
                MultiSet.Transient<ITerm> labels = ((MultiSet.Immutable)this.incomplete.getOrDefault(scopeOrVar, MultiSet.Immutable.of())).melt();
                if (labels.remove((ITerm)label) == 0) {
                    removedEdges.__insert((Object)CriticalEdge.of(scopeOrVar, label));
                }
                if (labels.isEmpty()) {
                    this.incomplete.__remove(scopeOrVar);
                } else {
                    this.incomplete.__put(scopeOrVar, labels.freeze());
                }
            }));
            return removedEdges.freeze();
        }

        @Override
        public void update(ITermVar var, IUniDisunifier unifier) {
            MultiSet updatedLabels = (MultiSet)this.incomplete.__remove((Object)var);
            if (updatedLabels != null) {
                Transient.getVarOrScope(var, unifier).ifPresent(scopeOrVar -> {
                    MultiSet.Transient labels = ((MultiSet.Immutable)this.incomplete.getOrDefault(scopeOrVar, MultiSet.Immutable.of())).melt();
                    updatedLabels.forEach(labels::add);
                    this.incomplete.__put(scopeOrVar, labels.freeze());
                });
            }
        }

        @Override
        public Immutable freeze() {
            return new Immutable(this.spec, this.incomplete.freeze());
        }

        public static Transient of(Spec spec) {
            return new Transient(spec, (Map.Transient<ITerm, MultiSet.Immutable<ITerm>>)Map.Transient.of());
        }
    }
}

