/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.log;

import java.util.Collections;
import mb.statix.solver.log.IDebugContext;
import mb.statix.solver.log.Log;
import org.metaborg.util.log.Level;

public class LazyDebugContext
implements IDebugContext {
    private final IDebugContext debug;
    private int offset;
    private final Log log;

    public LazyDebugContext(IDebugContext debug) {
        this(debug, 0, new Log());
    }

    private LazyDebugContext(IDebugContext debug, int offset, Log log) {
        this.debug = debug;
        this.offset = offset;
        this.log = log;
    }

    @Override
    public Level getLevel() {
        return this.debug.getLevel();
    }

    @Override
    public int getDepth() {
        return this.debug.getDepth() + this.offset;
    }

    @Override
    public boolean isEnabled(Level level) {
        return this.debug.isEnabled(level);
    }

    @Override
    public IDebugContext subContext() {
        return new LazyDebugContext(this.debug, this.offset + 1, this.log);
    }

    @Override
    public void info(String fmt, Object ... args) {
        if (this.isEnabled(Level.Info)) {
            this.log.append(Level.Info, String.valueOf(this.prefix()) + fmt, args);
        }
    }

    @Override
    public void warn(String fmt, Object ... args) {
        if (this.isEnabled(Level.Warn)) {
            this.log.append(Level.Warn, String.valueOf(this.prefix()) + fmt, args);
        }
    }

    @Override
    public void error(String fmt, Object ... args) {
        if (this.isEnabled(Level.Error)) {
            this.log.append(Level.Error, String.valueOf(this.prefix()) + fmt, args);
        }
    }

    @Override
    public void log(Level level, String fmt, Object ... args) {
        if (this.isEnabled(level)) {
            this.log.append(level, String.valueOf(this.prefix()) + fmt, args);
        }
    }

    public void commit() {
        this.log.flush(this.debug);
    }

    public Log clear() {
        return this.log.clear();
    }

    private String prefix() {
        return String.join((CharSequence)"", Collections.nCopies(this.offset, "| "));
    }
}

