/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.log;

import mb.statix.solver.log.IDebugContext;
import org.metaborg.util.log.Level;

public class Log {
    private Entry first;
    private Entry last;

    public Log() {
        this(null, null);
    }

    private Log(Entry first, Entry last) {
        this.first = first;
        this.last = last;
    }

    public boolean isEmpty() {
        return this.first == null;
    }

    public void append(Level level, String message, Object[] args) {
        Entry next = new Entry(level, message, args);
        if (this.isEmpty()) {
            this.first = next;
            this.last = next;
        } else {
            this.last.next = next;
            this.last = next;
        }
    }

    public void flush(IDebugContext debug) {
        while (!this.isEmpty()) {
            debug.log(this.first.level, this.first.message, this.first.args);
            this.first = this.first.next;
        }
    }

    public void absorb(Log log) {
        if (!log.isEmpty()) {
            if (this.isEmpty()) {
                this.first = log.first;
                this.last = log.last;
            } else {
                this.last.next = log.first;
                this.last = log.last;
            }
            log.first = null;
            log.last = null;
        }
    }

    public Log clear() {
        Log log = new Log(this.first, this.last);
        this.first = null;
        this.last = null;
        return log;
    }

    private static class Entry {
        private final Level level;
        private final String message;
        private final Object[] args;
        private Entry next;

        private Entry(Level level, String message, Object[] args) {
            this.level = level;
            this.message = message;
            this.args = args;
        }
    }
}

