/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.log;

import java.util.Collections;
import mb.statix.solver.log.IDebugContext;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.Level;

public class LoggerDebugContext
implements IDebugContext {
    private final ILogger logger;
    private final Level level;
    private final int depth;

    public LoggerDebugContext(ILogger logger) {
        this(logger, Level.Info, 0);
    }

    public LoggerDebugContext(ILogger logger, Level level) {
        this(logger, level, 0);
    }

    private LoggerDebugContext(ILogger logger, Level level, int depth) {
        this.logger = logger;
        this.level = level;
        this.depth = depth;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public boolean isEnabled(Level level) {
        return this.level.compareTo(level) <= 0;
    }

    @Override
    public IDebugContext subContext() {
        return new LoggerDebugContext(this.logger, this.level, this.depth + 1);
    }

    @Override
    public void info(String fmt, Object ... args) {
        if (this.isEnabled(Level.Info)) {
            this.logger.info(String.valueOf(this.prefix()) + fmt, args);
        }
    }

    @Override
    public void warn(String fmt, Object ... args) {
        if (this.isEnabled(Level.Warn)) {
            this.logger.warn(String.valueOf(this.prefix()) + fmt, args);
        }
    }

    @Override
    public void error(String fmt, Object ... args) {
        if (this.isEnabled(Level.Error)) {
            this.logger.error(String.valueOf(this.prefix()) + fmt, args);
        }
    }

    @Override
    public void log(Level level, String fmt, Object ... args) {
        if (this.isEnabled(level)) {
            this.logger.log(level, String.valueOf(this.prefix()) + fmt, args);
        }
    }

    private String prefix() {
        return String.join((CharSequence)"", Collections.nCopies(this.depth, "| "));
    }
}

