/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.persistent;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import mb.nabl2.terms.ITermVar;
import mb.statix.constraints.Constraints;
import mb.statix.constraints.messages.IMessage;
import mb.statix.constraints.messages.MessageKind;
import mb.statix.scopegraph.reference.CriticalEdge;
import mb.statix.solver.Delay;
import mb.statix.solver.IConstraint;
import mb.statix.solver.IState;
import mb.statix.solver.completeness.ICompleteness;
import org.immutables.serial.Serial;
import org.immutables.value.Value;

@Value.Immutable
@Serial.Version(value=42L)
public abstract class ASolverResult {
    @Value.Parameter
    public abstract IState.Immutable state();

    @Value.Parameter
    public abstract Map<IConstraint, IMessage> messages();

    @Value.Parameter
    public abstract Map<IConstraint, Delay> delays();

    @Value.Parameter
    public abstract Map<ITermVar, ITermVar> existentials();

    @Value.Parameter
    public abstract Set<ITermVar> updatedVars();

    @Value.Parameter
    public abstract Set<CriticalEdge> removedEdges();

    @Value.Parameter
    public abstract ICompleteness.Immutable completeness();

    public boolean hasErrors() {
        return this.messages().values().stream().anyMatch(m -> m.kind().equals(MessageKind.ERROR));
    }

    public Delay delay() {
        ImmutableSet.Builder vars = ImmutableSet.builder();
        ImmutableSet.Builder scopes = ImmutableSet.builder();
        this.delays().values().stream().forEach(d -> {
            vars.addAll(d.vars());
            scopes.addAll(d.criticalEdges());
        });
        return new Delay((Iterable<? extends ITermVar>)vars.build(), (Iterable<CriticalEdge>)scopes.build());
    }

    public IConstraint delayed() {
        return Constraints.conjoin(this.delays().keySet());
    }
}

