/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.persistent;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.terms.stratego.TermIndex;
import mb.nabl2.terms.stratego.TermOrigin;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.substitution.PersistentSubstitution;
import mb.nabl2.terms.unification.OccursException;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.nabl2.terms.unification.ud.Diseq;
import mb.nabl2.terms.unification.ud.IUniDisunifier;
import mb.nabl2.util.Tuple2;
import mb.statix.constraints.CArith;
import mb.statix.constraints.CAstId;
import mb.statix.constraints.CAstProperty;
import mb.statix.constraints.CConj;
import mb.statix.constraints.CEqual;
import mb.statix.constraints.CExists;
import mb.statix.constraints.CFalse;
import mb.statix.constraints.CInequal;
import mb.statix.constraints.CNew;
import mb.statix.constraints.CResolveQuery;
import mb.statix.constraints.CTellEdge;
import mb.statix.constraints.CTellRel;
import mb.statix.constraints.CTrue;
import mb.statix.constraints.CTry;
import mb.statix.constraints.CUser;
import mb.statix.constraints.Constraints;
import mb.statix.constraints.messages.IMessage;
import mb.statix.constraints.messages.MessageUtil;
import mb.statix.scopegraph.INameResolution;
import mb.statix.scopegraph.IScopeGraph;
import mb.statix.scopegraph.reference.CriticalEdge;
import mb.statix.scopegraph.reference.Env;
import mb.statix.scopegraph.reference.IncompleteDataException;
import mb.statix.scopegraph.reference.IncompleteEdgeException;
import mb.statix.scopegraph.reference.ResolutionException;
import mb.statix.scopegraph.terms.AScope;
import mb.statix.scopegraph.terms.Scope;
import mb.statix.solver.ConstraintContext;
import mb.statix.solver.Delay;
import mb.statix.solver.IConstraint;
import mb.statix.solver.IConstraintStore;
import mb.statix.solver.IState;
import mb.statix.solver.ITermProperty;
import mb.statix.solver.completeness.Completeness;
import mb.statix.solver.completeness.ICompleteness;
import mb.statix.solver.completeness.IsComplete;
import mb.statix.solver.log.IDebugContext;
import mb.statix.solver.log.LazyDebugContext;
import mb.statix.solver.log.NullDebugContext;
import mb.statix.solver.persistent.BagTermProperty;
import mb.statix.solver.persistent.SingletonTermProperty;
import mb.statix.solver.persistent.Solver;
import mb.statix.solver.persistent.SolverResult;
import mb.statix.solver.persistent.query.ConstraintQueries;
import mb.statix.solver.query.IQueryFilter;
import mb.statix.solver.query.IQueryMin;
import mb.statix.solver.query.ResolutionDelayException;
import mb.statix.solver.store.BaseConstraintStore;
import mb.statix.spec.ApplyResult;
import mb.statix.spec.Rule;
import mb.statix.spec.RuleUtil;
import mb.statix.spec.Spec;
import mb.statix.spoofax.StatixTerms;
import org.metaborg.util.functions.Predicate2;
import org.metaborg.util.log.Level;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;
import org.metaborg.util.task.RateLimitedCancel;

class GreedySolver {
    private static final int CANCEL_RATE = 42;
    private static final int MAX_DEPTH = 32;
    private final Spec spec;
    private final IDebugContext debug;
    private final IConstraintStore constraints;
    private final ICompleteness.Transient completeness;
    private final IState.Immutable initialState;
    private final ConstraintContext params;
    private final IProgress progress;
    private final ICancel cancel;
    private Map<ITermVar, ITermVar> existentials = null;
    private final List<ITermVar> updatedVars = Lists.newArrayList();
    private final List<CriticalEdge> removedEdges = Lists.newArrayList();
    private final Map<IConstraint, IMessage> failed = Maps.newHashMap();

    public GreedySolver(Spec spec, IState.Immutable state, IConstraint initialConstraint, IsComplete _isComplete, IDebugContext debug, IProgress progress, ICancel cancel) {
        this.spec = spec;
        this.initialState = state;
        this.debug = debug;
        this.constraints = new BaseConstraintStore(debug);
        this.constraints.add(initialConstraint);
        this.completeness = Completeness.Transient.of(spec);
        this.completeness.add(initialConstraint, this.initialState.unifier());
        IsComplete isComplete = (s, l, st) -> this.completeness.isComplete((Scope)s, (ITerm)l, st.unifier()) && _isComplete.test(s, l, st);
        this.params = new ConstraintContext(isComplete, debug);
        this.progress = progress;
        this.cancel = new RateLimitedCancel(cancel, 42);
    }

    public GreedySolver(Spec spec, IState.Immutable state, Iterable<IConstraint> constraints, Map<IConstraint, Delay> delays, ICompleteness.Immutable completeness, IDebugContext debug, IProgress progress, ICancel cancel) {
        this.spec = spec;
        this.initialState = state;
        this.debug = debug;
        this.constraints = new BaseConstraintStore(debug);
        this.constraints.addAll(constraints);
        this.constraints.delayAll(delays.entrySet());
        this.completeness = completeness.melt();
        IsComplete isComplete = (s, l, st) -> this.completeness.isComplete((Scope)s, (ITerm)l, st.unifier());
        this.params = new ConstraintContext(isComplete, debug);
        this.progress = progress;
        this.cancel = new RateLimitedCancel(cancel, 42);
    }

    public SolverResult solve() throws InterruptedException {
        IConstraint constraint;
        this.debug.info("Solving constraints", new Object[0]);
        IState.Immutable state = this.initialState;
        while ((constraint = this.constraints.remove()) != null) {
            state = this.k(state, constraint, 32);
        }
        if (this.constraints.activeSize() > 0) {
            this.debug.warn("Expected no remaining active constraints, but got ", this.constraints.activeSize());
        }
        Map<IConstraint, Delay> delayed = this.constraints.delayed();
        this.debug.info("Solved constraints with {} failed and {} remaining constraint(s).", this.failed.size(), this.constraints.delayedSize());
        for (Delay delayedConstraint : delayed.values()) {
            this.debug.info(" * {}", delayedConstraint.toString());
        }
        Map<ITermVar, ITermVar> existentials = Optional.ofNullable(this.existentials).orElse((Map<ITermVar, ITermVar>)ImmutableMap.of());
        return SolverResult.of(state, this.failed, delayed, existentials, this.updatedVars, this.removedEdges, this.completeness.freeze());
    }

    private IState.Immutable success(IConstraint constraint, IState.Immutable state, Collection<ITermVar> updatedVars, Collection<IConstraint> newConstraints, Map<Delay, IConstraint> delayedConstraints, Map<ITermVar, ITermVar> existentials, int fuel) throws InterruptedException {
        IDebugContext subDebug = this.debug.subContext();
        if (this.existentials == null) {
            this.existentials = existentials;
        }
        IUniDisunifier.Immutable unifier = state.unifier();
        this.completeness.updateAll(updatedVars, unifier);
        this.constraints.activateFromVars(updatedVars, this.debug);
        this.updatedVars.addAll(updatedVars);
        this.completeness.addAll(newConstraints, unifier);
        if (subDebug.isEnabled(Level.Info) && !newConstraints.isEmpty()) {
            subDebug.info("Simplified to:", new Object[0]);
            for (IConstraint newConstraint : newConstraints) {
                subDebug.info(" * {}", Solver.toString(newConstraint, unifier));
            }
        }
        delayedConstraints.forEach((d, c) -> this.constraints.delay((IConstraint)c, (Delay)d));
        this.completeness.addAll(delayedConstraints.values(), unifier);
        if (subDebug.isEnabled(Level.Info) && !delayedConstraints.isEmpty()) {
            subDebug.info("Delayed:", new Object[0]);
            for (IConstraint delayedConstraint : delayedConstraints.values()) {
                subDebug.info(" * {}", Solver.toString(delayedConstraint, unifier));
            }
        }
        Set<CriticalEdge> removedEdges = this.completeness.remove(constraint, unifier);
        this.constraints.activateFromEdges(removedEdges, this.debug);
        this.removedEdges.addAll(removedEdges);
        for (IConstraint newConstraint : newConstraints) {
            state = this.k(state, newConstraint, fuel - 1);
        }
        return state;
    }

    private IState.Immutable success(IConstraint c, IState.Immutable newState, int fuel) throws InterruptedException {
        return this.success(c, newState, (Collection<ITermVar>)ImmutableSet.of(), (Collection<IConstraint>)ImmutableList.of(), (Map<Delay, IConstraint>)ImmutableMap.of(), (Map<ITermVar, ITermVar>)ImmutableMap.of(), fuel);
    }

    private IState.Immutable successNew(IConstraint c, IState.Immutable newState, Collection<IConstraint> newConstraints, int fuel) throws InterruptedException {
        return this.success(c, newState, (Collection<ITermVar>)ImmutableSet.of(), newConstraints, (Map<Delay, IConstraint>)ImmutableMap.of(), (Map<ITermVar, ITermVar>)ImmutableMap.of(), fuel);
    }

    private IState.Immutable successDelay(IConstraint c, IState.Immutable newState, Delay delay, int fuel) throws InterruptedException {
        return this.success(c, newState, (Collection<ITermVar>)ImmutableSet.of(), (Collection<IConstraint>)ImmutableList.of(), (Map<Delay, IConstraint>)ImmutableMap.of((Object)delay, (Object)c), (Map<ITermVar, ITermVar>)ImmutableMap.of(), fuel);
    }

    private IState.Immutable fail(IConstraint constraint, IState.Immutable state) {
        this.failed.put(constraint, MessageUtil.findClosestMessage(constraint));
        Set<CriticalEdge> removedEdges = this.completeness.remove(constraint, state.unifier());
        this.constraints.activateFromEdges(removedEdges, this.debug);
        this.removedEdges.addAll(removedEdges);
        return state;
    }

    private IState.Immutable queue(IConstraint constraint, IState.Immutable state) {
        this.constraints.add(constraint);
        return state;
    }

    private IState.Immutable k(final IState.Immutable state, final IConstraint constraint, final int fuel) throws InterruptedException {
        this.cancel.throwIfCancelled();
        if (fuel <= 0) {
            return this.queue(constraint, state);
        }
        if (this.debug.isEnabled(Level.Info)) {
            this.debug.info("Solving {}", constraint.toString(Solver.shallowTermFormatter(state.unifier())));
        }
        return constraint.matchOrThrow(new IConstraint.CheckedCases<IState.Immutable, InterruptedException>(){

            @Override
            public IState.Immutable caseArith(CArith c) throws InterruptedException {
                IUniDisunifier.Immutable unifier = state.unifier();
                Optional<ITerm> term1 = c.expr1().isTerm();
                Optional<ITerm> term2 = c.expr2().isTerm();
                try {
                    if (c.op().isEquals() && term1.isPresent()) {
                        int i2 = c.expr2().eval(unifier);
                        CEqual eq = new CEqual(term1.get(), (ITerm)TermBuild.B.newInt(i2), c);
                        return GreedySolver.this.successNew(c, state, (Collection)ImmutableList.of((Object)eq), fuel);
                    }
                    if (c.op().isEquals() && term2.isPresent()) {
                        int i1 = c.expr1().eval(unifier);
                        CEqual eq = new CEqual((ITerm)TermBuild.B.newInt(i1), term2.get(), c);
                        return GreedySolver.this.successNew(c, state, (Collection)ImmutableList.of((Object)eq), fuel);
                    }
                    int i1 = c.expr1().eval(unifier);
                    int i2 = c.expr2().eval(unifier);
                    if (c.op().test(i1, i2)) {
                        return GreedySolver.this.success(c, state, fuel);
                    }
                    return GreedySolver.this.fail(c, state);
                }
                catch (Delay d) {
                    return GreedySolver.this.successDelay(c, state, d, fuel);
                }
            }

            @Override
            public IState.Immutable caseConj(CConj c) throws InterruptedException {
                List<IConstraint> newConstraints = Constraints.disjoin(c);
                return GreedySolver.this.successNew(c, state, newConstraints, fuel);
            }

            @Override
            public IState.Immutable caseEqual(CEqual c) throws InterruptedException {
                ITerm term1 = c.term1();
                ITerm term2 = c.term2();
                IDebugContext debug = GreedySolver.this.params.debug();
                IUniDisunifier.Immutable unifier = state.unifier();
                try {
                    IUniDisunifier.Result result = unifier.unify(term1, term2).orElse(null);
                    if (result != null) {
                        if (debug.isEnabled(Level.Info)) {
                            debug.info("Unification succeeded: {}", result.result());
                        }
                        IState.Immutable newState = state.withUnifier(result.unifier());
                        Set.Immutable<ITermVar> updatedVars = ((IUnifier.Immutable)result.result()).varSet();
                        return GreedySolver.this.success(c, newState, updatedVars, (Collection)ImmutableList.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), fuel);
                    }
                    if (debug.isEnabled(Level.Info)) {
                        debug.info("Unification failed: {} != {}", unifier.toString(term1), unifier.toString(term2));
                    }
                    return GreedySolver.this.fail(c, state);
                }
                catch (OccursException e) {
                    if (debug.isEnabled(Level.Info)) {
                        debug.info("Unification failed: {} != {}", unifier.toString(term1), unifier.toString(term2));
                    }
                    return GreedySolver.this.fail(c, state);
                }
            }

            @Override
            public IState.Immutable caseExists(CExists c) throws InterruptedException {
                ImmutableMap.Builder existentialsBuilder = ImmutableMap.builder();
                IState.Immutable newState = state;
                for (ITermVar var : c.vars()) {
                    Tuple2<ITermVar, IState.Immutable> varAndState = newState.freshVar(var);
                    ITermVar freshVar = varAndState._1();
                    newState = varAndState._2();
                    existentialsBuilder.put((Object)var, (Object)freshVar);
                }
                ImmutableMap existentials = existentialsBuilder.build();
                ISubstitution.Immutable subst = PersistentSubstitution.Immutable.of((Map<ITermVar, ? extends ITerm>)existentials);
                IConstraint newConstraint = c.constraint().apply(subst).withCause(c.cause().orElse(null));
                return GreedySolver.this.success(c, newState, (Collection)ImmutableSet.of(), Constraints.disjoin(newConstraint), (Map)ImmutableMap.of(), (Map)existentials, fuel);
            }

            @Override
            public IState.Immutable caseFalse(CFalse c) {
                return GreedySolver.this.fail(c, state);
            }

            @Override
            public IState.Immutable caseInequal(CInequal c) throws InterruptedException {
                ITerm term1 = c.term1();
                ITerm term2 = c.term2();
                IDebugContext debug = GreedySolver.this.params.debug();
                IUniDisunifier.Immutable unifier = state.unifier();
                IUniDisunifier.Result result = unifier.disunify(c.universals(), term1, term2).orElse(null);
                if (result != null) {
                    if (debug.isEnabled(Level.Info)) {
                        debug.info("Disunification succeeded: {}", result);
                    }
                    IState.Immutable newState = state.withUnifier(result.unifier());
                    Set updatedVars = ((Optional)result.result()).map(Diseq::varSet).orElse((Set)ImmutableSet.of());
                    return GreedySolver.this.success(c, newState, updatedVars, (Collection)ImmutableList.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), fuel);
                }
                if (debug.isEnabled(Level.Info)) {
                    debug.info("Disunification failed", new Object[0]);
                }
                return GreedySolver.this.fail(c, state);
            }

            @Override
            public IState.Immutable caseNew(CNew c) throws InterruptedException {
                List<ITerm> terms = c.terms();
                ArrayList newConstraints = Lists.newArrayList();
                IState.Immutable newState = state;
                for (ITerm t : terms) {
                    String base = TermMatch.M.var(ITermVar::getName).match(t).orElse("s");
                    Tuple2<Scope, IState.Immutable> ss = newState.freshScope(base);
                    newConstraints.add(new CEqual(t, (ITerm)ss._1(), c));
                    newState = ss._2();
                }
                return GreedySolver.this.success(c, newState, (Collection)ImmutableList.of(), newConstraints, (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), fuel);
            }

            @Override
            public IState.Immutable caseResolveQuery(CResolveQuery c) throws InterruptedException {
                ITerm relation = c.relation();
                IQueryFilter filter = c.filter();
                IQueryMin min2 = c.min();
                ITerm scopeTerm = c.scopeTerm();
                ITerm resultTerm = c.resultTerm();
                IUniDisunifier.Immutable unifier = state.unifier();
                if (!unifier.isGround(scopeTerm)) {
                    return GreedySolver.this.successDelay(c, state, Delay.ofVars(unifier.getVars(scopeTerm)), fuel);
                }
                Scope scope = AScope.matcher().match(scopeTerm, unifier).orElse(null);
                if (scope == null) {
                    GreedySolver.this.debug.error("Expected scope, got {}", unifier.toString(scopeTerm));
                    GreedySolver.this.fail(constraint, state);
                }
                try {
                    Predicate2<Scope, ITerm> isComplete = (s, l) -> GreedySolver.this.params.isComplete((Scope)s, (ITerm)l, state);
                    ConstraintQueries cq = new ConstraintQueries(GreedySolver.this.spec, state, GreedySolver.this.params, GreedySolver.this.progress, GreedySolver.this.cancel);
                    INameResolution<Scope, ITerm, ITerm> nameResolution = Solver.nameResolutionBuilder().withLabelWF(cq.getLabelWF(filter.getLabelWF())).withDataWF(cq.getDataWF(filter.getDataWF())).withLabelOrder(cq.getLabelOrder(min2.getLabelOrder())).withDataEquiv(cq.getDataEquiv(min2.getDataEquiv())).withEdgeComplete(isComplete).withDataComplete(isComplete).build(state.scopeGraph(), relation);
                    Env<Scope, ITerm, ITerm> paths = nameResolution.resolve(scope, GreedySolver.this.cancel);
                    List pathTerms = (List)Streams.stream(paths).map(StatixTerms::explicate).collect(ImmutableList.toImmutableList());
                    CEqual C2 = new CEqual(resultTerm, (ITerm)TermBuild.B.newList(pathTerms), c);
                    return GreedySolver.this.successNew(c, state, (Collection)ImmutableList.of((Object)C2), fuel);
                }
                catch (IncompleteDataException e) {
                    GreedySolver.this.params.debug().info("Query resolution delayed: {}", e.getMessage());
                    return GreedySolver.this.successDelay(c, state, Delay.ofCriticalEdge(CriticalEdge.of((ITerm)e.scope(), (ITerm)e.relation())), fuel);
                }
                catch (IncompleteEdgeException e) {
                    GreedySolver.this.params.debug().info("Query resolution delayed: {}", e.getMessage());
                    return GreedySolver.this.successDelay(c, state, Delay.ofCriticalEdge(CriticalEdge.of((ITerm)e.scope(), (ITerm)e.label())), fuel);
                }
                catch (ResolutionDelayException e) {
                    GreedySolver.this.params.debug().info("Query resolution delayed: {}", e.getMessage());
                    return GreedySolver.this.successDelay(c, state, e.getCause(), fuel);
                }
                catch (ResolutionException e) {
                    GreedySolver.this.params.debug().info("Query resolution failed: {}", e.getMessage());
                    return GreedySolver.this.fail(c, state);
                }
            }

            @Override
            public IState.Immutable caseTellEdge(CTellEdge c) throws InterruptedException {
                ITerm sourceTerm = c.sourceTerm();
                ITerm label = c.label();
                ITerm targetTerm = c.targetTerm();
                IUniDisunifier.Immutable unifier = state.unifier();
                if (!unifier.isGround(sourceTerm)) {
                    return GreedySolver.this.successDelay(c, state, Delay.ofVars(unifier.getVars(sourceTerm)), fuel);
                }
                if (!unifier.isGround(targetTerm)) {
                    return GreedySolver.this.successDelay(c, state, Delay.ofVars(unifier.getVars(targetTerm)), fuel);
                }
                Scope source = AScope.matcher().match(sourceTerm, unifier).orElse(null);
                if (source == null) {
                    GreedySolver.this.debug.error("Expected source scope, got {}", unifier.toString(sourceTerm));
                    return GreedySolver.this.fail(c, state);
                }
                if (GreedySolver.this.params.isClosed(source, state)) {
                    return GreedySolver.this.fail(c, state);
                }
                Scope target = AScope.matcher().match(targetTerm, unifier).orElse(null);
                if (target == null) {
                    GreedySolver.this.debug.error("Expected target scope, got {}", unifier.toString(targetTerm));
                    return GreedySolver.this.fail(c, state);
                }
                IScopeGraph.Immutable<Scope, ITerm, ITerm> scopeGraph = state.scopeGraph().addEdge(source, label, target);
                return GreedySolver.this.success(c, state.withScopeGraph(scopeGraph), fuel);
            }

            @Override
            public IState.Immutable caseTellRel(CTellRel c) throws InterruptedException {
                ITerm scopeTerm = c.scopeTerm();
                ITerm relation = c.relation();
                ITerm datum = c.datumTerm();
                IUniDisunifier.Immutable unifier = state.unifier();
                if (!unifier.isGround(scopeTerm)) {
                    return GreedySolver.this.successDelay(c, state, Delay.ofVars(unifier.getVars(scopeTerm)), fuel);
                }
                Scope scope = AScope.matcher().match(scopeTerm, unifier).orElse(null);
                if (scope == null) {
                    GreedySolver.this.debug.error("Expected scope , got {}", unifier.toString(scopeTerm));
                    return GreedySolver.this.fail(c, state);
                }
                if (GreedySolver.this.params.isClosed(scope, state)) {
                    return GreedySolver.this.fail(c, state);
                }
                IScopeGraph.Immutable<Scope, ITerm, ITerm> scopeGraph = state.scopeGraph().addDatum(scope, relation, datum);
                return GreedySolver.this.success(c, state.withScopeGraph(scopeGraph), fuel);
            }

            @Override
            public IState.Immutable caseTermId(CAstId c) throws InterruptedException {
                ITerm term = c.astTerm();
                ITerm idTerm = c.idTerm();
                IUniDisunifier.Immutable unifier = state.unifier();
                if (!unifier.isGround(term)) {
                    return GreedySolver.this.successDelay(c, state, Delay.ofVars(unifier.getVars(term)), fuel);
                }
                Optional<Scope> maybeScope = AScope.matcher().match(term, unifier);
                if (maybeScope.isPresent()) {
                    AScope scope = maybeScope.get();
                    CEqual eq = new CEqual(idTerm, scope);
                    return GreedySolver.this.successNew(c, state, (Collection)ImmutableList.of((Object)eq), fuel);
                }
                Optional<TermIndex> maybeIndex = TermIndex.get(unifier.findTerm(term));
                if (maybeIndex.isPresent()) {
                    ITerm indexTerm = TermOrigin.copy(term, maybeIndex.get());
                    CEqual eq = new CEqual(idTerm, indexTerm);
                    return GreedySolver.this.successNew(c, state, (Collection)ImmutableList.of((Object)eq), fuel);
                }
                return GreedySolver.this.fail(c, state);
            }

            @Override
            public IState.Immutable caseTermProperty(CAstProperty c) throws InterruptedException {
                ITerm idTerm = c.idTerm();
                ITerm prop = c.property();
                ITerm value = c.value();
                IUniDisunifier.Immutable unifier = state.unifier();
                if (!unifier.isGround(idTerm)) {
                    return GreedySolver.this.successDelay(c, state, Delay.ofVars(unifier.getVars(idTerm)), fuel);
                }
                Optional<TermIndex> maybeIndex = TermIndex.matcher().match(idTerm, unifier);
                if (maybeIndex.isPresent()) {
                    ITermProperty property;
                    TermIndex index = maybeIndex.get();
                    Tuple2<TermIndex, ITerm> key = Tuple2.of(index, prop);
                    switch (c.op()) {
                        case ADD: {
                            property = (ITermProperty)state.termProperties().getOrDefault(key, (Object)BagTermProperty.of());
                            if (!property.multiplicity().equals((Object)ITermProperty.Multiplicity.BAG)) {
                                return GreedySolver.this.fail(c, state);
                            }
                            property = property.addValue(value);
                            break;
                        }
                        case SET: {
                            if (state.termProperties().containsKey(key)) {
                                return GreedySolver.this.fail(c, state);
                            }
                            property = SingletonTermProperty.of(value);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown op " + (Object)((Object)c.op()));
                        }
                    }
                    IState.Immutable newState = state.withTermProperties((Map.Immutable<Tuple2<TermIndex, ITerm>, ITermProperty>)state.termProperties().__put(key, (Object)property));
                    return GreedySolver.this.success(c, newState, fuel);
                }
                return GreedySolver.this.fail(c, state);
            }

            @Override
            public IState.Immutable caseTrue(CTrue c) throws InterruptedException {
                return GreedySolver.this.success(c, state, fuel);
            }

            @Override
            public IState.Immutable caseTry(CTry c) throws InterruptedException {
                try {
                    if (Solver.entails(GreedySolver.this.spec, state, c.constraint(), GreedySolver.this.params::isComplete, new NullDebugContext(), GreedySolver.this.progress.subProgress(1), GreedySolver.this.cancel)) {
                        return GreedySolver.this.success(c, state, fuel);
                    }
                    return GreedySolver.this.fail(c, state);
                }
                catch (Delay e) {
                    GreedySolver.this.params.debug().info("Try delayed: {}", e.getMessage());
                    return GreedySolver.this.successDelay(c, state, e, fuel);
                }
            }

            @Override
            public IState.Immutable caseUser(CUser c) throws InterruptedException {
                String name = c.name();
                List<ITerm> args = c.args();
                LazyDebugContext proxyDebug = new LazyDebugContext(GreedySolver.this.debug);
                IDebugContext debug = GreedySolver.this.params.debug();
                ImmutableList<Rule> rules = GreedySolver.this.spec.rules().getRules(name);
                List<Tuple2<Rule, ApplyResult>> results = RuleUtil.applyOrderedAll(state, rules, args, c);
                if (results.isEmpty()) {
                    debug.info("No rule applies", new Object[0]);
                    return GreedySolver.this.fail(c, state);
                }
                if (results.size() == 1) {
                    ApplyResult applyResult = results.get(0)._2();
                    proxyDebug.info("Rule accepted", new Object[0]);
                    proxyDebug.info("| Implied equalities: {}", applyResult.diff());
                    proxyDebug.commit();
                    return GreedySolver.this.success(c, applyResult.state(), applyResult.diff().varSet(), Constraints.disjoin(applyResult.body()), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), fuel);
                }
                Set<ITermVar> stuckVars = results.stream().flatMap(r -> Streams.stream(((ApplyResult)r._2()).guard())).flatMap(g -> g.varSet().stream()).collect(Collectors.toSet());
                proxyDebug.info("Rule delayed (multiple conditional matches)", new Object[0]);
                return GreedySolver.this.successDelay(c, state, Delay.ofVars(stuckVars), fuel);
            }
        });
    }
}

