/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.persistent;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.unification.UnifierFormatter;
import mb.nabl2.terms.unification.ud.IUniDisunifier;
import mb.nabl2.util.TermFormatter;
import mb.statix.scopegraph.INameResolution;
import mb.statix.scopegraph.reference.FastNameResolution;
import mb.statix.scopegraph.terms.Scope;
import mb.statix.solver.Delay;
import mb.statix.solver.IConstraint;
import mb.statix.solver.IState;
import mb.statix.solver.completeness.ICompleteness;
import mb.statix.solver.completeness.IsComplete;
import mb.statix.solver.log.IDebugContext;
import mb.statix.solver.persistent.GreedySolver;
import mb.statix.solver.persistent.SolverResult;
import mb.statix.spec.Spec;
import org.metaborg.util.log.Level;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;

public class Solver {
    private Solver() {
    }

    public static SolverResult solve(Spec spec, IState.Immutable state, IConstraint constraint, IDebugContext debug, IProgress progress, ICancel cancel) throws InterruptedException {
        return Solver.solve(spec, state, constraint, (s, l, st) -> true, debug, progress, cancel);
    }

    public static SolverResult solve(Spec spec, IState.Immutable state, IConstraint constraint, IsComplete isComplete, IDebugContext debug, IProgress progress, ICancel cancel) throws InterruptedException {
        return new GreedySolver(spec, state, constraint, isComplete, debug, progress, cancel).solve();
    }

    public static SolverResult solve(Spec spec, IState.Immutable state, Iterable<IConstraint> constraints, Map<IConstraint, Delay> delays, ICompleteness.Immutable completeness, IDebugContext debug, IProgress progress, ICancel cancel) throws InterruptedException {
        return new GreedySolver(spec, state, constraints, delays, completeness, debug, progress, cancel).solve();
    }

    public static boolean entails(Spec spec, IState.Immutable state, IConstraint constraint, IsComplete isComplete, IDebugContext debug, IProgress progress, ICancel cancel) throws Delay, InterruptedException {
        SolverResult result;
        IUniDisunifier.Immutable unifier = state.unifier();
        if (debug.isEnabled(Level.Info)) {
            debug.info("Checking entailment of {}", Solver.toString(constraint, unifier));
        }
        if ((result = Solver.solve(spec, state, constraint, isComplete, debug.subContext(), progress, cancel)).hasErrors()) {
            debug.info("Constraints not entailed: errors", new Object[0]);
            return false;
        }
        IState.Immutable newState = result.state();
        Sets.SetView newVars = Sets.difference(newState.vars(), state.vars());
        Sets.SetView newScopes = Sets.difference(newState.scopes(), state.scopes());
        if (!result.delays().isEmpty()) {
            Delay delay = result.delay().removeAll((Iterable<? extends ITermVar>)newVars, (Iterable<? extends ITerm>)newScopes);
            if (delay.criticalEdges().isEmpty() && delay.vars().isEmpty()) {
                debug.info("Constraints not entailed: internal stuckness", new Object[0]);
                return false;
            }
            debug.info("Cannot decide constraint entailment: unsolved constraints", new Object[0]);
            throw delay;
        }
        IUniDisunifier.Immutable newUnifier = newState.unifier().removeAll((Iterable)newVars).unifier();
        if (!Sets.intersection(newUnifier.freeVarSet(), (Set)newVars).isEmpty()) {
            debug.info("Constraints not entailed: internal variables leak", new Object[0]);
            return false;
        }
        Sets.SetView unifiedVars = Sets.difference(newUnifier.varSet(), unifier.varSet());
        if (!unifiedVars.isEmpty()) {
            debug.info("Cannot decide constraint entailment: unified rigid vars)", new Object[0]);
            throw Delay.ofVars((Iterable<ITermVar>)unifiedVars);
        }
        List<ITermVar> disunifiedVars = newUnifier.disequalities().stream().filter(diseq -> diseq.toTuple().apply(unifier::disunify).map(r -> ((Optional)r.result()).isPresent()).orElse(true)).flatMap(diseq -> diseq.varSet().stream()).collect(Collectors.toList());
        if (!disunifiedVars.isEmpty()) {
            debug.info("Cannot decide constraint entailment: disunified rigid vars)", new Object[0]);
            throw Delay.ofVars(disunifiedVars);
        }
        debug.info("Constraints entailed", new Object[0]);
        return true;
    }

    static void printTrace(IConstraint failed, IUniDisunifier.Immutable unifier, IDebugContext debug) {
        IConstraint constraint = failed;
        while (constraint != null) {
            debug.error(" * {}", constraint.toString(Solver.shallowTermFormatter(unifier)));
            constraint = constraint.cause().orElse(null);
        }
    }

    static String toString(IConstraint constraint, IUniDisunifier.Immutable unifier) {
        return constraint.toString(Solver.shallowTermFormatter(unifier));
    }

    static String toString(Iterable<IConstraint> constraints, IUniDisunifier.Immutable unifier) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (IConstraint constraint : constraints) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(constraint.toString(Solver.shallowTermFormatter(unifier)));
        }
        return sb.toString();
    }

    public static INameResolution.Builder<Scope, ITerm, ITerm> nameResolutionBuilder() {
        return FastNameResolution.builder();
    }

    public static TermFormatter shallowTermFormatter(IUniDisunifier unifier) {
        return new UnifierFormatter(unifier, 4);
    }
}

