/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.persistent;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import mb.nabl2.terms.ITermVar;
import mb.statix.constraints.messages.IMessage;
import mb.statix.scopegraph.reference.CriticalEdge;
import mb.statix.solver.Delay;
import mb.statix.solver.IConstraint;
import mb.statix.solver.IState;
import mb.statix.solver.completeness.ICompleteness;
import mb.statix.solver.persistent.ASolverResult;

public final class SolverResult
extends ASolverResult
implements Serializable {
    private final IState.Immutable state;
    private final ImmutableMap<IConstraint, IMessage> messages;
    private final ImmutableMap<IConstraint, Delay> delays;
    private final ImmutableMap<ITermVar, ITermVar> existentials;
    private final ImmutableSet<ITermVar> updatedVars;
    private final ImmutableSet<CriticalEdge> removedEdges;
    private final ICompleteness.Immutable completeness;
    private static final long serialVersionUID = 42L;

    private SolverResult(IState.Immutable state, Map<? extends IConstraint, ? extends IMessage> messages, Map<? extends IConstraint, ? extends Delay> delays, Map<? extends ITermVar, ? extends ITermVar> existentials, Iterable<? extends ITermVar> updatedVars, Iterable<? extends CriticalEdge> removedEdges, ICompleteness.Immutable completeness) {
        this.state = Objects.requireNonNull(state, "state");
        this.messages = ImmutableMap.copyOf(messages);
        this.delays = ImmutableMap.copyOf(delays);
        this.existentials = ImmutableMap.copyOf(existentials);
        this.updatedVars = ImmutableSet.copyOf(updatedVars);
        this.removedEdges = ImmutableSet.copyOf(removedEdges);
        this.completeness = Objects.requireNonNull(completeness, "completeness");
    }

    private SolverResult(SolverResult original, IState.Immutable state, ImmutableMap<IConstraint, IMessage> messages, ImmutableMap<IConstraint, Delay> delays, ImmutableMap<ITermVar, ITermVar> existentials, ImmutableSet<ITermVar> updatedVars, ImmutableSet<CriticalEdge> removedEdges, ICompleteness.Immutable completeness) {
        this.state = state;
        this.messages = messages;
        this.delays = delays;
        this.existentials = existentials;
        this.updatedVars = updatedVars;
        this.removedEdges = removedEdges;
        this.completeness = completeness;
    }

    @Override
    public IState.Immutable state() {
        return this.state;
    }

    public ImmutableMap<IConstraint, IMessage> messages() {
        return this.messages;
    }

    public ImmutableMap<IConstraint, Delay> delays() {
        return this.delays;
    }

    public ImmutableMap<ITermVar, ITermVar> existentials() {
        return this.existentials;
    }

    public ImmutableSet<ITermVar> updatedVars() {
        return this.updatedVars;
    }

    public ImmutableSet<CriticalEdge> removedEdges() {
        return this.removedEdges;
    }

    @Override
    public ICompleteness.Immutable completeness() {
        return this.completeness;
    }

    public final SolverResult withState(IState.Immutable value) {
        if (this.state == value) {
            return this;
        }
        IState.Immutable newValue = Objects.requireNonNull(value, "state");
        return new SolverResult(this, newValue, this.messages, this.delays, this.existentials, this.updatedVars, this.removedEdges, this.completeness);
    }

    public final SolverResult withMessages(Map<? extends IConstraint, ? extends IMessage> entries) {
        if (this.messages == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new SolverResult(this, this.state, (ImmutableMap<IConstraint, IMessage>)newValue, this.delays, this.existentials, this.updatedVars, this.removedEdges, this.completeness);
    }

    public final SolverResult withDelays(Map<? extends IConstraint, ? extends Delay> entries) {
        if (this.delays == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new SolverResult(this, this.state, this.messages, (ImmutableMap<IConstraint, Delay>)newValue, this.existentials, this.updatedVars, this.removedEdges, this.completeness);
    }

    public final SolverResult withExistentials(Map<? extends ITermVar, ? extends ITermVar> entries) {
        if (this.existentials == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new SolverResult(this, this.state, this.messages, this.delays, (ImmutableMap<ITermVar, ITermVar>)newValue, this.updatedVars, this.removedEdges, this.completeness);
    }

    public final SolverResult withUpdatedVars(ITermVar ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new SolverResult(this, this.state, this.messages, this.delays, this.existentials, (ImmutableSet<ITermVar>)newValue, this.removedEdges, this.completeness);
    }

    public final SolverResult withUpdatedVars(Iterable<? extends ITermVar> elements) {
        if (this.updatedVars == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new SolverResult(this, this.state, this.messages, this.delays, this.existentials, (ImmutableSet<ITermVar>)newValue, this.removedEdges, this.completeness);
    }

    public final SolverResult withRemovedEdges(CriticalEdge ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new SolverResult(this, this.state, this.messages, this.delays, this.existentials, this.updatedVars, (ImmutableSet<CriticalEdge>)newValue, this.completeness);
    }

    public final SolverResult withRemovedEdges(Iterable<? extends CriticalEdge> elements) {
        if (this.removedEdges == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new SolverResult(this, this.state, this.messages, this.delays, this.existentials, this.updatedVars, (ImmutableSet<CriticalEdge>)newValue, this.completeness);
    }

    public final SolverResult withCompleteness(ICompleteness.Immutable value) {
        if (this.completeness == value) {
            return this;
        }
        ICompleteness.Immutable newValue = Objects.requireNonNull(value, "completeness");
        return new SolverResult(this, this.state, this.messages, this.delays, this.existentials, this.updatedVars, this.removedEdges, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SolverResult && this.equalTo((SolverResult)another);
    }

    private boolean equalTo(SolverResult another) {
        return this.state.equals(another.state) && this.messages.equals(another.messages) && this.delays.equals(another.delays) && this.existentials.equals(another.existentials) && this.updatedVars.equals(another.updatedVars) && this.removedEdges.equals(another.removedEdges) && this.completeness.equals(another.completeness);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.state.hashCode();
        h += (h << 5) + this.messages.hashCode();
        h += (h << 5) + this.delays.hashCode();
        h += (h << 5) + this.existentials.hashCode();
        h += (h << 5) + this.updatedVars.hashCode();
        h += (h << 5) + this.removedEdges.hashCode();
        h += (h << 5) + this.completeness.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SolverResult").omitNullValues().add("state", (Object)this.state).add("messages", this.messages).add("delays", this.delays).add("existentials", this.existentials).add("updatedVars", this.updatedVars).add("removedEdges", this.removedEdges).add("completeness", (Object)this.completeness).toString();
    }

    public static SolverResult of(IState.Immutable state, Map<IConstraint, IMessage> messages, Map<IConstraint, Delay> delays, Map<ITermVar, ITermVar> existentials, Set<ITermVar> updatedVars, Set<CriticalEdge> removedEdges, ICompleteness.Immutable completeness) {
        return SolverResult.of(state, messages, delays, existentials, updatedVars, removedEdges, completeness);
    }

    public static SolverResult of(IState.Immutable state, Map<? extends IConstraint, ? extends IMessage> messages, Map<? extends IConstraint, ? extends Delay> delays, Map<? extends ITermVar, ? extends ITermVar> existentials, Iterable<? extends ITermVar> updatedVars, Iterable<? extends CriticalEdge> removedEdges, ICompleteness.Immutable completeness) {
        return new SolverResult(state, messages, delays, existentials, updatedVars, removedEdges, completeness);
    }

    public static SolverResult copyOf(ASolverResult instance) {
        if (instance instanceof SolverResult) {
            return (SolverResult)instance;
        }
        return SolverResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ SolverResult(SolverResult solverResult, IState.Immutable immutable, ImmutableMap immutableMap, ImmutableMap immutableMap2, ImmutableMap immutableMap3, ImmutableSet immutableSet, ImmutableSet immutableSet2, ICompleteness.Immutable immutable2, SolverResult solverResult2) {
        this(solverResult, immutable, (ImmutableMap<IConstraint, IMessage>)immutableMap, (ImmutableMap<IConstraint, Delay>)immutableMap2, (ImmutableMap<ITermVar, ITermVar>)immutableMap3, (ImmutableSet<ITermVar>)immutableSet, (ImmutableSet<CriticalEdge>)immutableSet2, immutable2);
    }

    public static final class Builder {
        private static final long INIT_BIT_STATE = 1L;
        private static final long INIT_BIT_COMPLETENESS = 2L;
        private long initBits = 3L;
        private IState.Immutable state;
        private ImmutableMap.Builder<IConstraint, IMessage> messages = ImmutableMap.builder();
        private ImmutableMap.Builder<IConstraint, Delay> delays = ImmutableMap.builder();
        private ImmutableMap.Builder<ITermVar, ITermVar> existentials = ImmutableMap.builder();
        private ImmutableSet.Builder<ITermVar> updatedVars = ImmutableSet.builder();
        private ImmutableSet.Builder<CriticalEdge> removedEdges = ImmutableSet.builder();
        private ICompleteness.Immutable completeness;

        private Builder() {
        }

        public final Builder from(ASolverResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.state(instance.state());
            this.putAllMessages(instance.messages());
            this.putAllDelays(instance.delays());
            this.putAllExistentials(instance.existentials());
            this.addAllUpdatedVars(instance.updatedVars());
            this.addAllRemovedEdges(instance.removedEdges());
            this.completeness(instance.completeness());
            return this;
        }

        public final Builder state(IState.Immutable state) {
            this.state = Objects.requireNonNull(state, "state");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder putMessages(IConstraint key, IMessage value) {
            this.messages.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putMessages(Map.Entry<? extends IConstraint, ? extends IMessage> entry) {
            this.messages.put(entry);
            return this;
        }

        public final Builder messages(Map<? extends IConstraint, ? extends IMessage> entries) {
            this.messages = ImmutableMap.builder();
            return this.putAllMessages(entries);
        }

        public final Builder putAllMessages(Map<? extends IConstraint, ? extends IMessage> entries) {
            this.messages.putAll(entries);
            return this;
        }

        public final Builder putDelays(IConstraint key, Delay value) {
            this.delays.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putDelays(Map.Entry<? extends IConstraint, ? extends Delay> entry) {
            this.delays.put(entry);
            return this;
        }

        public final Builder delays(Map<? extends IConstraint, ? extends Delay> entries) {
            this.delays = ImmutableMap.builder();
            return this.putAllDelays(entries);
        }

        public final Builder putAllDelays(Map<? extends IConstraint, ? extends Delay> entries) {
            this.delays.putAll(entries);
            return this;
        }

        public final Builder putExistentials(ITermVar key, ITermVar value) {
            this.existentials.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putExistentials(Map.Entry<? extends ITermVar, ? extends ITermVar> entry) {
            this.existentials.put(entry);
            return this;
        }

        public final Builder existentials(Map<? extends ITermVar, ? extends ITermVar> entries) {
            this.existentials = ImmutableMap.builder();
            return this.putAllExistentials(entries);
        }

        public final Builder putAllExistentials(Map<? extends ITermVar, ? extends ITermVar> entries) {
            this.existentials.putAll(entries);
            return this;
        }

        public final Builder addUpdatedVars(ITermVar element) {
            this.updatedVars.add((Object)element);
            return this;
        }

        public final Builder addUpdatedVars(ITermVar ... elements) {
            this.updatedVars.add((Object[])elements);
            return this;
        }

        public final Builder updatedVars(Iterable<? extends ITermVar> elements) {
            this.updatedVars = ImmutableSet.builder();
            return this.addAllUpdatedVars(elements);
        }

        public final Builder addAllUpdatedVars(Iterable<? extends ITermVar> elements) {
            this.updatedVars.addAll(elements);
            return this;
        }

        public final Builder addRemovedEdges(CriticalEdge element) {
            this.removedEdges.add((Object)element);
            return this;
        }

        public final Builder addRemovedEdges(CriticalEdge ... elements) {
            this.removedEdges.add((Object[])elements);
            return this;
        }

        public final Builder removedEdges(Iterable<? extends CriticalEdge> elements) {
            this.removedEdges = ImmutableSet.builder();
            return this.addAllRemovedEdges(elements);
        }

        public final Builder addAllRemovedEdges(Iterable<? extends CriticalEdge> elements) {
            this.removedEdges.addAll(elements);
            return this;
        }

        public final Builder completeness(ICompleteness.Immutable completeness) {
            this.completeness = Objects.requireNonNull(completeness, "completeness");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public SolverResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new SolverResult(null, this.state, this.messages.build(), this.delays.build(), this.existentials.build(), this.updatedVars.build(), this.removedEdges.build(), this.completeness, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("state");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("completeness");
            }
            return "Cannot build SolverResult, some of required attributes are not set " + attributes;
        }
    }
}

