/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.persistent.query;

import com.google.common.collect.ImmutableList;
import java.util.List;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.unification.ud.IUniDisunifier;
import mb.statix.scopegraph.reference.DataLeq;
import mb.statix.scopegraph.reference.ResolutionException;
import mb.statix.solver.Delay;
import mb.statix.solver.IConstraint;
import mb.statix.solver.IState;
import mb.statix.solver.completeness.IsComplete;
import mb.statix.solver.log.IDebugContext;
import mb.statix.solver.persistent.Solver;
import mb.statix.solver.query.ResolutionDelayException;
import mb.statix.spec.Rule;
import mb.statix.spec.Spec;
import org.metaborg.util.log.Level;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;

class ConstraintDataLeq
implements DataLeq<ITerm> {
    private final Spec spec;
    private final Rule constraint;
    private final IState.Immutable state;
    private final IsComplete isComplete;
    private final IDebugContext debug;
    private final IProgress progress;
    private final ICancel cancel;
    private volatile Boolean alwaysTrue;

    public ConstraintDataLeq(Spec spec, Rule constraint, IState.Immutable state, IsComplete isComplete, IDebugContext debug, IProgress progress, ICancel cancel) {
        this.spec = spec;
        this.constraint = constraint;
        this.state = state;
        this.isComplete = isComplete;
        this.debug = debug;
        this.progress = progress;
        this.cancel = cancel;
    }

    @Override
    public boolean leq(ITerm datum1, ITerm datum2) throws ResolutionException, InterruptedException {
        IUniDisunifier.Immutable unifier;
        block7: {
            IConstraint result;
            block6: {
                unifier = this.state.unifier();
                try {
                    result = this.constraint.apply((List<? extends ITerm>)ImmutableList.of((Object)datum1, (Object)datum2), unifier).orElse(null);
                    if (result != null) break block6;
                    return false;
                }
                catch (Delay d) {
                    throw new ResolutionDelayException("Data order delayed.", d);
                }
            }
            if (!Solver.entails(this.spec, this.state, result, this.isComplete, this.debug, this.progress.subProgress(1), this.cancel)) break block7;
            if (this.debug.isEnabled(Level.Info)) {
                this.debug.info("{} shadows {}", unifier.toString(datum1), unifier.toString(datum2));
            }
            return true;
        }
        if (this.debug.isEnabled(Level.Info)) {
            this.debug.info("{} does not shadow {}", unifier.toString(datum1), unifier.toString(datum2));
        }
        return false;
    }

    @Override
    public boolean alwaysTrue() throws InterruptedException {
        if (this.alwaysTrue != null) {
            return this.alwaysTrue;
        }
        this.alwaysTrue = this.constraint.isAlways(this.spec).orElse(false);
        return this.alwaysTrue;
    }
}

