/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.query;

import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.regexp.IRegExp;
import mb.nabl2.regexp.IRegExpMatcher;
import mb.nabl2.regexp.RegExpMatcher;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.TermFormatter;
import mb.statix.solver.query.IQueryFilter;
import mb.statix.spec.Rule;

public class QueryFilter
implements IQueryFilter,
Serializable {
    private static final long serialVersionUID = 1L;
    private final IRegExpMatcher<ITerm> pathWf;
    private final Rule dataWf;

    public QueryFilter(IRegExp<ITerm> pathWf, Rule dataConstraint) {
        this(RegExpMatcher.create(pathWf), dataConstraint);
    }

    private QueryFilter(IRegExpMatcher<ITerm> pathWf, Rule dataConstraint) {
        this.pathWf = pathWf;
        this.dataWf = dataConstraint;
    }

    @Override
    public IRegExpMatcher<ITerm> getLabelWF() {
        return this.pathWf;
    }

    @Override
    public Rule getDataWF() {
        return this.dataWf;
    }

    @Override
    public Multiset<ITermVar> getVars() {
        ImmutableMultiset.Builder vars = ImmutableMultiset.builder();
        vars.addAll(this.dataWf.varSet());
        return vars.build();
    }

    @Override
    public IQueryFilter apply(ISubstitution.Immutable subst) {
        return new QueryFilter(this.pathWf, this.dataWf.apply(subst));
    }

    @Override
    public IQueryFilter apply(IRenaming subst) {
        return new QueryFilter(this.pathWf, this.dataWf.apply(subst));
    }

    @Override
    public String toString(TermFormatter termToString) {
        StringBuilder sb = new StringBuilder();
        sb.append("filter ");
        sb.append(this.pathWf);
        sb.append(" and ");
        sb.append(this.dataWf.toString(termToString));
        return sb.toString();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryFilter that = (QueryFilter)o;
        return Objects.equals(this.pathWf, that.pathWf) && Objects.equals(this.dataWf, that.dataWf);
    }

    public int hashCode() {
        return Objects.hash(this.pathWf, this.dataWf);
    }
}

